/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.resourceadapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.resourceadapter.WorkManager;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class ActivationImpl
extends AbstractMetadata
implements Activation {
    private static final long serialVersionUID = 1L;
    protected TransactionSupportEnum transactionSupport;
    protected Map<String, String> configProperties;
    protected List<AdminObject> adminObjects;
    protected List<ConnectionDefinition> connectionDefinitions;
    protected List<String> beanValidationGroups;
    protected String bootstrapContext;
    protected String archive;
    protected String id;
    protected WorkManager workmanager;

    public ActivationImpl(String id, String archive, TransactionSupportEnum transactionSupport, List<ConnectionDefinition> connectionDefinitions, List<AdminObject> adminObjects, Map<String, String> configProperties, List<String> beanValidationGroups, String bootstrapContext, WorkManager workmanager, Map<String, String> expressions) {
        super(expressions);
        this.id = id;
        this.archive = archive;
        this.transactionSupport = transactionSupport;
        if (connectionDefinitions != null) {
            this.connectionDefinitions = new ArrayList<ConnectionDefinition>(connectionDefinitions.size());
            this.connectionDefinitions.addAll(connectionDefinitions);
        } else {
            this.connectionDefinitions = null;
        }
        if (adminObjects != null) {
            this.adminObjects = new ArrayList<AdminObject>(adminObjects.size());
            this.adminObjects.addAll(adminObjects);
        } else {
            this.adminObjects = null;
        }
        if (configProperties != null) {
            this.configProperties = new TreeMap<String, String>();
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = null;
        }
        if (beanValidationGroups != null) {
            this.beanValidationGroups = new ArrayList<String>(beanValidationGroups.size());
            this.beanValidationGroups.addAll(beanValidationGroups);
        } else {
            this.beanValidationGroups = null;
        }
        this.bootstrapContext = bootstrapContext;
        this.workmanager = workmanager;
    }

    @Override
    public TransactionSupportEnum getTransactionSupport() {
        return this.transactionSupport;
    }

    @Override
    public List<ConnectionDefinition> getConnectionDefinitions() {
        if (this.connectionDefinitions == null) {
            return null;
        }
        return Collections.unmodifiableList(this.connectionDefinitions);
    }

    @Override
    public List<AdminObject> getAdminObjects() {
        return this.adminObjects == null ? null : Collections.unmodifiableList(this.adminObjects);
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return this.configProperties == null ? null : Collections.unmodifiableMap(this.configProperties);
    }

    @Override
    public List<String> getBeanValidationGroups() {
        return this.beanValidationGroups == null ? null : Collections.unmodifiableList(this.beanValidationGroups);
    }

    @Override
    public String getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getArchive() {
        return this.archive;
    }

    @Override
    public WorkManager getWorkManager() {
        return this.workmanager;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminObjects == null ? 0 : this.adminObjects.hashCode());
        result = 31 * result + (this.beanValidationGroups == null ? 0 : this.beanValidationGroups.hashCode());
        result = 31 * result + (this.bootstrapContext == null ? 0 : this.bootstrapContext.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.connectionDefinitions == null ? 0 : this.connectionDefinitions.hashCode());
        result = 31 * result + (this.transactionSupport == null ? 0 : this.transactionSupport.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.archive == null ? 0 : this.archive.hashCode());
        result = 31 * result + (this.workmanager == null ? 0 : this.workmanager.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivationImpl)) {
            return false;
        }
        ActivationImpl other = (ActivationImpl)obj;
        if (this.adminObjects == null ? other.adminObjects != null : !this.adminObjects.equals(other.adminObjects)) {
            return false;
        }
        if (this.beanValidationGroups == null ? other.beanValidationGroups != null : !this.beanValidationGroups.equals(other.beanValidationGroups)) {
            return false;
        }
        if (this.bootstrapContext == null ? other.bootstrapContext != null : !this.bootstrapContext.equals(other.bootstrapContext)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.connectionDefinitions == null ? other.connectionDefinitions != null : !this.connectionDefinitions.equals(other.connectionDefinitions)) {
            return false;
        }
        if (this.transactionSupport != other.transactionSupport) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.archive == null ? other.archive != null : !this.archive.equals(other.archive)) {
            return false;
        }
        return !(this.workmanager == null ? other.workmanager != null : !this.workmanager.equals(other.workmanager));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        if (this.archive != null) {
            sb.append("<resource-adapter");
        } else {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<ironjacamar");
        }
        if (this.id != null) {
            sb.append(" ").append("id").append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.archive != null) {
            sb.append("<").append("archive").append(">");
            sb.append(this.archive);
            sb.append("</").append("archive").append(">");
        }
        if (this.beanValidationGroups != null && !this.beanValidationGroups.isEmpty()) {
            sb.append("<").append("bean-validation-groups").append(">");
            for (String bvg : this.beanValidationGroups) {
                sb.append("<").append("bean-validation-group").append(">");
                sb.append(bvg);
                sb.append("</").append("bean-validation-group").append(">");
            }
            sb.append("</").append("bean-validation-groups").append(">");
        }
        if (this.bootstrapContext != null) {
            sb.append("<").append("bootstrap-context").append(">");
            sb.append(this.bootstrapContext);
            sb.append("</").append("bootstrap-context").append(">");
        }
        if (this.configProperties != null && !this.configProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append("config-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("config-property").append(">");
            }
        }
        if (this.transactionSupport != null) {
            sb.append("<").append("transaction-support").append(">");
            sb.append((Object)this.transactionSupport);
            sb.append("</").append("transaction-support").append(">");
        }
        if (this.workmanager != null) {
            sb.append(this.workmanager);
        }
        if (this.connectionDefinitions != null && !this.connectionDefinitions.isEmpty()) {
            sb.append("<").append("connection-definitions").append(">");
            for (ConnectionDefinition cd : this.connectionDefinitions) {
                sb.append(cd);
            }
            sb.append("</").append("connection-definitions").append(">");
        }
        if (this.adminObjects != null && !this.adminObjects.isEmpty()) {
            sb.append("<").append("admin-objects").append(">");
            for (AdminObject ao : this.adminObjects) {
                sb.append(ao);
            }
            sb.append("</").append("admin-objects").append(">");
        }
        if (this.archive != null) {
            sb.append("</resource-adapter>");
        } else {
            sb.append("</ironjacamar>");
        }
        return sb.toString();
    }
}

