/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.resourceadapter;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class AdminObjectImpl
extends AbstractMetadata
implements AdminObject {
    private static final long serialVersionUID = 1L;
    private Map<String, String> configProperties;
    private String className;
    private String jndiName;
    private String id;
    private Boolean enabled;

    public AdminObjectImpl(Map<String, String> configProperties, String className, String jndiName, String id, Boolean enabled, Map<String, String> expressions) {
        super(expressions);
        if (configProperties != null) {
            this.configProperties = new TreeMap<String, String>();
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new TreeMap<String, String>();
        }
        this.className = className;
        this.jndiName = jndiName;
        this.id = id;
        this.enabled = enabled;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminObjectImpl)) {
            return false;
        }
        AdminObjectImpl other = (AdminObjectImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<admin-object");
        if (this.className != null) {
            sb.append(" ").append("class-name").append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append("jndi-name").append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null && !Defaults.ENABLED.equals(this.enabled)) {
            sb.append(" ").append("enabled").append("=\"").append(this.enabled).append("\"");
        }
        if (this.id != null) {
            sb.append(" ").append("id").append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && !this.configProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append("config-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("config-property").append(">");
            }
        }
        sb.append("</admin-object>");
        return sb.toString();
    }
}

