/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.resourceadapter;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Pool;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.metadata.common.Security;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.metadata.common.Validation;
import org.ironjacamar.common.api.metadata.common.XaPool;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class ConnectionDefinitionImpl
extends AbstractMetadata
implements ConnectionDefinition {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> configProperties;
    protected String className;
    protected String jndiName;
    protected String id;
    protected Boolean enabled;
    protected Boolean useCcm;
    protected Pool pool;
    protected Timeout timeout;
    protected Validation validation;
    protected Security security;
    protected Recovery recovery;
    protected Boolean isXA;
    protected Boolean sharable;
    protected Boolean enlistment;
    private Boolean connectable;
    private Boolean tracking;

    public ConnectionDefinitionImpl(Map<String, String> configProperties, String className, String jndiName, String id, Boolean enabled, Boolean useCcm, Boolean sharable, Boolean enlistment, Boolean connectable, Boolean tracking, Pool pool, Timeout timeout, Validation validation, Security security, Recovery recovery, Boolean isXA, Map<String, String> expressions) {
        super(expressions);
        if (configProperties != null) {
            this.configProperties = new TreeMap<String, String>();
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new TreeMap<String, String>();
        }
        this.className = className;
        this.jndiName = jndiName;
        this.id = id;
        this.enabled = enabled;
        this.useCcm = useCcm;
        this.pool = pool;
        this.timeout = timeout;
        this.validation = validation;
        this.security = security;
        this.recovery = recovery;
        this.isXA = isXA;
        this.sharable = sharable;
        this.enlistment = enlistment;
        this.connectable = connectable;
        this.tracking = tracking;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Boolean isUseCcm() {
        return this.useCcm;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public Timeout getTimeout() {
        return this.timeout;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    public Security getSecurity() {
        return this.security;
    }

    @Override
    public Recovery getRecovery() {
        return this.recovery;
    }

    @Override
    public Boolean isXa() {
        return this.pool instanceof XaPool || this.isXA != null ? this.isXA : Boolean.FALSE;
    }

    @Override
    public Boolean isSharable() {
        return this.sharable;
    }

    @Override
    public Boolean isEnlistment() {
        return this.enlistment;
    }

    @Override
    public Boolean isConnectable() {
        return this.connectable;
    }

    @Override
    public Boolean isTracking() {
        return this.tracking;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.recovery == null ? 0 : this.recovery.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.timeout == null ? 0 : this.timeout.hashCode());
        result = 31 * result + (this.useCcm == null ? 0 : this.useCcm.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        result = 31 * result + (this.isXA == null ? 0 : this.isXA.hashCode());
        result = 31 * result + (this.sharable == null ? 0 : this.sharable.hashCode());
        result = 31 * result + (this.enlistment == null ? 0 : this.enlistment.hashCode());
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDefinitionImpl)) {
            return false;
        }
        ConnectionDefinitionImpl other = (ConnectionDefinitionImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.pool == null ? other.pool != null : !this.pool.equals(other.pool)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.recovery == null ? other.recovery != null : !this.recovery.equals(other.recovery)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.timeout == null ? other.timeout != null : !this.timeout.equals(other.timeout)) {
            return false;
        }
        if (this.useCcm == null ? other.useCcm != null : !this.useCcm.equals(other.useCcm)) {
            return false;
        }
        if (this.validation == null ? other.validation != null : !this.validation.equals(other.validation)) {
            return false;
        }
        if (this.isXA == null ? other.isXA != null : !this.isXA.equals(other.isXA)) {
            return false;
        }
        if (this.sharable == null ? other.sharable != null : !this.sharable.equals(other.sharable)) {
            return false;
        }
        if (this.enlistment == null ? other.enlistment != null : !this.enlistment.equals(other.enlistment)) {
            return false;
        }
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        return !(this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<connection-definition");
        if (this.className != null) {
            sb.append(" ").append("class-name").append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append("jndi-name").append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null && !Defaults.ENABLED.equals(this.enabled)) {
            sb.append(" ").append("enabled").append("=\"").append(this.enabled).append("\"");
        }
        if (this.id != null) {
            sb.append(" ").append("id").append("=\"").append(this.id).append("\"");
        }
        if (this.useCcm != null && !Defaults.USE_CCM.equals(this.useCcm)) {
            sb.append(" ").append("use-ccm").append("=\"").append(this.useCcm).append("\"");
        }
        if (this.sharable != null && !Defaults.SHARABLE.equals(this.sharable)) {
            sb.append(" ").append("sharable").append("=\"").append(this.sharable).append("\"");
        }
        if (this.enlistment != null && !Defaults.ENLISTMENT.equals(this.enlistment)) {
            sb.append(" ").append("enlistment").append("=\"").append(this.enlistment).append("\"");
        }
        if (this.connectable != null && !Defaults.CONNECTABLE.equals(this.connectable)) {
            sb.append(" ").append("connectable").append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append("tracking").append("=\"").append(this.tracking).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && !this.configProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append("config-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("config-property").append(">");
            }
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.timeout != null) {
            sb.append(this.timeout);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</connection-definition>");
        return sb.toString();
    }
}

