/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.resourceadapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.Activations;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.resourceadapter.WorkManager;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.MetadataParser;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.CommonIronJacamarParser;
import org.ironjacamar.common.metadata.resourceadapter.ActivationImpl;
import org.ironjacamar.common.metadata.resourceadapter.ActivationsImpl;
import org.jboss.logging.Messages;

public class ResourceAdapterParser
extends CommonIronJacamarParser
implements MetadataParser<Activations> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    @Override
    public Activations parse(XMLStreamReader reader) throws Exception {
        int iterate;
        Activations adapters = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (reader.getLocalName()) {
                    case "resource-adapters": {
                        adapters = this.parseResourceAdapters(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return adapters;
    }

    @Override
    public void store(Activations metadata, XMLStreamWriter writer) throws Exception {
        if (metadata != null && writer != null) {
            writer.writeStartElement("resource-adapters");
            for (Activation a : metadata.getActivations()) {
                writer.writeStartElement("resource-adapter");
                if (a.getId() != null) {
                    writer.writeAttribute("id", a.getValue("id", a.getId()));
                }
                writer.writeStartElement("archive");
                writer.writeCharacters(a.getValue("archive", a.getArchive()));
                writer.writeEndElement();
                this.storeCommon(a, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private Activations parseResourceAdapters(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<Activation> resourceAdapters = new ArrayList<Activation>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("resource-adapters".equals(reader.getLocalName())) {
                        resourceAdapters.trimToSize();
                        return new ActivationsImpl(resourceAdapters);
                    }
                    switch (reader.getLocalName()) {
                        case "resource-adapter": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "resource-adapter": {
                            resourceAdapters.add(this.parseResourceAdapter(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Activation parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        ArrayList<AdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        String id = null;
        String archive = null;
        TransactionSupportEnum transactionSupport = null;
        TreeMap<String, String> configProperties = null;
        WorkManager workmanager = null;
        Boolean isXA = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        int attributeSize = reader.getAttributeCount();
        block50: for (int i = 0; i < attributeSize; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "id": {
                    id = this.attributeAsString(reader, "id", expressions);
                    continue block50;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(reader.getAttributeLocalName(i), reader.getLocalName()));
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if ("resource-adapter".equals(reader.getLocalName())) {
                        return new ActivationImpl(id, archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext, workmanager, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "admin-objects": 
                        case "connection-definitions": 
                        case "bean-validation-groups": 
                        case "admin-object": 
                        case "connection-definition": 
                        case "bean-validation-group": 
                        case "bootstrap-context": 
                        case "config-property": 
                        case "transaction-support": 
                        case "archive": 
                        case "workmanager": {
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "admin-objects": 
                        case "connection-definitions": 
                        case "bean-validation-groups": {
                            break block6;
                        }
                        case "admin-object": {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<AdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block6;
                        }
                        case "connection-definition": {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<ConnectionDefinition>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader, isXA));
                            break block6;
                        }
                        case "bean-validation-group": {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader, this.getExpressionKey("bean-validation-group", Integer.toString(beanValidationGroups.size())), expressions));
                            break block6;
                        }
                        case "bootstrap-context": {
                            bootstrapContext = this.elementAsString(reader, "bootstrap-context", expressions);
                            break block6;
                        }
                        case "config-property": {
                            if (configProperties == null) {
                                configProperties = new TreeMap<String, String>();
                            }
                            this.parseConfigProperty(configProperties, reader, "config-property", expressions);
                            break block6;
                        }
                        case "transaction-support": {
                            transactionSupport = TransactionSupportEnum.valueOf(this.elementAsString(reader, "transaction-support", expressions));
                            if (transactionSupport != TransactionSupportEnum.XATransaction) break block6;
                            isXA = Boolean.TRUE;
                            break block6;
                        }
                        case "archive": {
                            archive = this.elementAsString(reader, "archive", expressions);
                            break block6;
                        }
                        case "workmanager": {
                            workmanager = this.parseWorkManager(reader);
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

