/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ironjacamar.common.api.metadata.CopyUtil;
import org.ironjacamar.common.api.metadata.spec.AdminObject;
import org.ironjacamar.common.api.metadata.spec.ConfigProperty;
import org.ironjacamar.common.api.metadata.spec.XsdString;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class AdminObjectImpl
extends AbstractMetadata
implements AdminObject {
    private static final long serialVersionUID = 1L;
    private XsdString adminobjectInterface;
    private XsdString adminobjectClass;
    private List<ConfigProperty> configProperties;
    private String id;

    public AdminObjectImpl(XsdString adminobjectInterface, XsdString adminobjectClass, List<ConfigProperty> configProperty, String id) {
        super(null);
        this.adminobjectInterface = adminobjectInterface;
        if (!XsdString.isNull(this.adminobjectInterface)) {
            this.adminobjectInterface.setTag("adminobject-interface");
        }
        this.adminobjectClass = adminobjectClass;
        if (!XsdString.isNull(this.adminobjectClass)) {
            this.adminobjectClass.setTag("adminobject-class");
        }
        this.configProperties = configProperty != null ? new ArrayList<ConfigProperty>(configProperty) : new ArrayList<ConfigProperty>(0);
        this.id = id;
    }

    @Override
    public XsdString getAdminobjectInterface() {
        return this.adminobjectInterface;
    }

    @Override
    public XsdString getAdminobjectClass() {
        return this.adminobjectClass;
    }

    @Override
    public List<ConfigProperty> getConfigProperties() {
        return Collections.unmodifiableList(this.configProperties);
    }

    public synchronized void forceConfigProperties(List<ConfigProperty> newContents) {
        this.configProperties = newContents != null ? new ArrayList<ConfigProperty>(newContents) : new ArrayList<ConfigProperty>(0);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AdminObject copy() {
        return new AdminObjectImpl(CopyUtil.clone(this.adminobjectInterface), CopyUtil.clone(this.adminobjectClass), CopyUtil.cloneList(this.configProperties), CopyUtil.cloneString(this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminobjectClass == null ? 0 : this.adminobjectClass.hashCode());
        result = 31 * result + (this.adminobjectInterface == null ? 0 : this.adminobjectInterface.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminObjectImpl)) {
            return false;
        }
        AdminObjectImpl other = (AdminObjectImpl)obj;
        if (this.adminobjectClass == null ? other.adminobjectClass != null : !this.adminobjectClass.equals(other.adminobjectClass)) {
            return false;
        }
        if (this.adminobjectInterface == null ? other.adminobjectInterface != null : !this.adminobjectInterface.equals(other.adminobjectInterface)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<adminobject");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        sb.append(this.adminobjectInterface);
        sb.append(this.adminobjectClass);
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        sb.append("</adminobject>");
        return sb.toString();
    }
}

