/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ironjacamar.common.api.metadata.CopyUtil;
import org.ironjacamar.common.api.metadata.spec.AuthenticationMechanism;
import org.ironjacamar.common.api.metadata.spec.CredentialInterfaceEnum;
import org.ironjacamar.common.api.metadata.spec.LocalizedXsdString;
import org.ironjacamar.common.api.metadata.spec.XsdString;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class AuthenticationMechanismImpl
extends AbstractMetadata
implements AuthenticationMechanism {
    private static final long serialVersionUID = 1L;
    private List<LocalizedXsdString> description;
    private XsdString authenticationMechanismType;
    private CredentialInterfaceEnum credentialInterface;
    private String id;
    private String cIId;

    public AuthenticationMechanismImpl(List<LocalizedXsdString> description, XsdString authenticationMechanismType, CredentialInterfaceEnum credentialInterface, String id, String cid) {
        super(null);
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag("description");
            }
        } else {
            this.description = new ArrayList<LocalizedXsdString>(0);
        }
        this.authenticationMechanismType = authenticationMechanismType;
        if (!XsdString.isNull(this.authenticationMechanismType)) {
            this.authenticationMechanismType.setTag("authentication-mechanism-type");
        }
        this.credentialInterface = credentialInterface;
        this.id = id;
        this.cIId = cid;
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    @Override
    public XsdString getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    @Override
    public CredentialInterfaceEnum getCredentialInterface() {
        return this.credentialInterface;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCredentialInterfaceId() {
        return this.cIId;
    }

    @Override
    public AuthenticationMechanism copy() {
        return new AuthenticationMechanismImpl(CopyUtil.cloneList(this.description), CopyUtil.clone(this.authenticationMechanismType), this.credentialInterface, CopyUtil.cloneString(this.id), CopyUtil.cloneString(this.cIId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticationMechanismType == null ? 0 : this.authenticationMechanismType.hashCode());
        result = 31 * result + (this.credentialInterface == null ? 0 : this.credentialInterface.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.cIId == null ? 0 : this.cIId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMechanismImpl)) {
            return false;
        }
        AuthenticationMechanismImpl other = (AuthenticationMechanismImpl)obj;
        if (this.authenticationMechanismType == null ? other.authenticationMechanismType != null : !this.authenticationMechanismType.equals(other.authenticationMechanismType)) {
            return false;
        }
        if (this.credentialInterface != other.credentialInterface) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.cIId == null ? other.cIId != null : !this.cIId.equals(other.cIId));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<authentication-mechanism");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.description != null) {
            for (LocalizedXsdString s : this.description) {
                sb.append(s);
            }
        }
        sb.append(this.authenticationMechanismType);
        sb.append("<").append("credential-interface").append(this.cIId == null ? "" : " id=\"" + this.cIId + "\"").append(">");
        sb.append((Object)this.credentialInterface);
        sb.append("</").append("credential-interface").append(">");
        sb.append("</authentication-mechanism>");
        return sb.toString();
    }
}

