/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import org.ironjacamar.common.api.metadata.CopyUtil;
import org.ironjacamar.common.api.metadata.spec.Icon;
import org.ironjacamar.common.api.metadata.spec.XsdString;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class IconImpl
extends AbstractMetadata
implements Icon {
    private static final long serialVersionUID = 1L;
    private XsdString smallIcon;
    private XsdString largeIcon;
    private String lang;
    private String id;

    public IconImpl(XsdString smallIcon, XsdString largeIcon, String lang, String id) {
        super(null);
        this.smallIcon = smallIcon;
        if (!XsdString.isNull(this.smallIcon)) {
            this.smallIcon.setTag("small-icon");
        }
        this.largeIcon = largeIcon;
        if (!XsdString.isNull(this.largeIcon)) {
            this.largeIcon.setTag("large-icon");
        }
        this.lang = lang;
        this.id = id;
    }

    @Override
    public XsdString getSmallIcon() {
        return this.smallIcon;
    }

    @Override
    public XsdString getLargeIcon() {
        return this.largeIcon;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setLang(String lng) {
        this.lang = lng;
    }

    @Override
    public Icon copy() {
        return new IconImpl(CopyUtil.clone(this.smallIcon), CopyUtil.clone(this.largeIcon), CopyUtil.cloneString(this.lang), CopyUtil.cloneString(this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.largeIcon == null ? 0 : this.largeIcon.hashCode());
        result = 31 * result + (this.smallIcon == null ? 0 : this.smallIcon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IconImpl)) {
            return false;
        }
        IconImpl other = (IconImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.largeIcon == null ? other.largeIcon != null : !this.largeIcon.equals(other.largeIcon)) {
            return false;
        }
        return !(this.smallIcon == null ? other.smallIcon != null : !this.smallIcon.equals(other.smallIcon));
    }

    public String toString() {
        return "<icon" + (this.id == null ? "" : " id=\"" + this.id + "\"") + (this.lang == null ? "" : " lang=\"" + this.lang + "\"") + ">" + (this.smallIcon == null ? "" : this.smallIcon) + (this.largeIcon == null ? "" : this.largeIcon) + "</icon>";
    }
}

