/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ironjacamar.common.api.metadata.CopyUtil;
import org.ironjacamar.common.api.metadata.MergeUtil;
import org.ironjacamar.common.api.metadata.spec.LicenseType;
import org.ironjacamar.common.api.metadata.spec.LocalizedXsdString;
import org.ironjacamar.common.api.metadata.spec.MergeableMetadata;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class LicenseTypeImpl
extends AbstractMetadata
implements LicenseType {
    private static final long serialVersionUID = 1L;
    private List<LocalizedXsdString> description;
    private boolean licenseRequired;
    private String id;
    private String licReqId;

    public LicenseTypeImpl(List<LocalizedXsdString> description, boolean licenseRequired, String id, String lrid) {
        super(null);
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag("description");
            }
        } else {
            this.description = new ArrayList<LocalizedXsdString>(0);
        }
        this.licenseRequired = licenseRequired;
        this.id = id;
        this.licReqId = lrid;
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    @Override
    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLicReqId() {
        return this.licReqId;
    }

    @Override
    public LicenseType merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof LicenseTypeImpl) {
            LicenseTypeImpl inputLicense = (LicenseTypeImpl)jmd;
            List<LocalizedXsdString> newDescription = MergeUtil.mergeList(this.description, inputLicense.description);
            boolean newLicenseRequired = this.licenseRequired || inputLicense.licenseRequired;
            String newId = this.id == null ? inputLicense.id : this.id;
            String newlrid = this.licReqId == null ? inputLicense.licReqId : this.licReqId;
            return new LicenseTypeImpl(newDescription, newLicenseRequired, newId, newlrid);
        }
        return this;
    }

    @Override
    public LicenseType copy() {
        return new LicenseTypeImpl(CopyUtil.cloneList(this.description), this.licenseRequired, CopyUtil.cloneString(this.id), CopyUtil.cloneString(this.licReqId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.licenseRequired ? 1231 : 1237);
        result = 31 * result + (this.licReqId == null ? 0 : this.licReqId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseTypeImpl)) {
            return false;
        }
        LicenseTypeImpl other = (LicenseTypeImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.licReqId == null ? other.licReqId != null : !this.licReqId.equals(other.licReqId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.licenseRequired == other.licenseRequired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<license");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.description != null) {
            for (LocalizedXsdString s : this.description) {
                sb.append(s);
            }
        }
        sb.append("<").append("license-required").append(this.licReqId == null ? "" : " id=\"" + this.licReqId + "\"").append(">");
        sb.append(this.licenseRequired);
        sb.append("</").append("license-required").append(">");
        sb.append("</license>");
        return sb.toString();
    }
}

