/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ironjacamar.common.api.metadata.CopyUtil;
import org.ironjacamar.common.api.metadata.MergeUtil;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.spec.AuthenticationMechanism;
import org.ironjacamar.common.api.metadata.spec.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.spec.MergeableMetadata;
import org.ironjacamar.common.api.metadata.spec.OutboundResourceAdapter;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class OutboundResourceAdapterImpl
extends AbstractMetadata
implements OutboundResourceAdapter {
    private static final long serialVersionUID = 1L;
    private List<ConnectionDefinition> connectionDefinition;
    private TransactionSupportEnum transactionSupport;
    private String transactionSupportId;
    private List<AuthenticationMechanism> authenticationMechanism;
    private boolean reauthenticationSupport;
    private String reauthenticationSupportId;
    private String id;

    public OutboundResourceAdapterImpl(List<ConnectionDefinition> connectionDefinition, TransactionSupportEnum transactionSupport, List<AuthenticationMechanism> authenticationMechanism, boolean reauthenticationSupport, String id, String transactionSupportId, String reauthenticationSupportId) {
        super(null);
        this.connectionDefinition = connectionDefinition != null ? new ArrayList<ConnectionDefinition>(connectionDefinition) : new ArrayList<ConnectionDefinition>(0);
        this.transactionSupport = transactionSupport;
        this.authenticationMechanism = authenticationMechanism != null ? new ArrayList<AuthenticationMechanism>(authenticationMechanism) : new ArrayList<AuthenticationMechanism>(0);
        this.reauthenticationSupport = reauthenticationSupport;
        this.id = id;
        this.reauthenticationSupportId = reauthenticationSupportId;
        this.transactionSupportId = transactionSupportId;
    }

    @Override
    public List<ConnectionDefinition> getConnectionDefinitions() {
        return Collections.unmodifiableList(this.connectionDefinition);
    }

    public synchronized void forceConnectionDefinitions(List<ConnectionDefinition> newContent) {
        this.connectionDefinition = newContent != null ? new ArrayList<ConnectionDefinition>(newContent) : new ArrayList<ConnectionDefinition>(0);
    }

    @Override
    public TransactionSupportEnum getTransactionSupport() {
        if (this.transactionSupport == null) {
            return TransactionSupportEnum.NoTransaction;
        }
        return this.transactionSupport;
    }

    public synchronized void forceTransactionSupport(TransactionSupportEnum newTransactionSupport) {
        this.transactionSupport = newTransactionSupport;
    }

    @Override
    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authenticationMechanism);
    }

    @Override
    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTransactionSupportId() {
        return this.transactionSupportId;
    }

    @Override
    public String getReauthenticationSupportId() {
        return this.reauthenticationSupportId;
    }

    @Override
    public boolean validationAsBoolean() {
        if (this.getConnectionDefinitions() == null || this.getConnectionDefinitions().isEmpty()) {
            return false;
        }
        ConnectionDefinition cdm = this.getConnectionDefinitions().get(0);
        return cdm.getManagedConnectionFactoryClass() != null && cdm.getConnectionFactoryInterface() != null && cdm.getConnectionFactoryImplClass() != null && cdm.getConnectionInterface() != null && cdm.getConnectionImplClass() != null;
    }

    @Override
    public OutboundResourceAdapter merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof OutboundResourceAdapterImpl) {
            OutboundResourceAdapterImpl input = (OutboundResourceAdapterImpl)jmd;
            String newId = this.id == null ? input.id : this.id;
            String newTransactionSupportId = this.transactionSupportId == null ? input.transactionSupportId : this.transactionSupportId;
            String newReauthenticationSupportId = this.reauthenticationSupportId == null ? input.reauthenticationSupportId : this.reauthenticationSupportId;
            ArrayList<ConnectionDefinition> newConnDef = new ArrayList<ConnectionDefinition>(this.connectionDefinition.size());
            newConnDef.addAll(this.connectionDefinition);
            for (ConnectionDefinition rcd : input.connectionDefinition) {
                boolean isNew = true;
                for (ConnectionDefinition lcd : this.connectionDefinition) {
                    if (lcd.getManagedConnectionFactoryClass() != null && !rcd.getManagedConnectionFactoryClass().equals(lcd.getManagedConnectionFactoryClass())) continue;
                    newConnDef.remove(lcd);
                    newConnDef.add((ConnectionDefinition)lcd.merge(rcd));
                    isNew = false;
                }
                if (!isNew) continue;
                newConnDef.add(rcd);
            }
            TransactionSupportEnum newTransactionSupport = this.transactionSupport == null ? input.transactionSupport : this.transactionSupport;
            boolean newReauthenticationSupport = this.reauthenticationSupport || input.reauthenticationSupport;
            List<AuthenticationMechanism> newAuthenticationMechanism = MergeUtil.mergeList(this.authenticationMechanism, input.authenticationMechanism);
            return new OutboundResourceAdapterImpl(newConnDef, newTransactionSupport, newAuthenticationMechanism, newReauthenticationSupport, newId, newTransactionSupportId, newReauthenticationSupportId);
        }
        return this;
    }

    @Override
    public OutboundResourceAdapter copy() {
        return new OutboundResourceAdapterImpl(CopyUtil.cloneList(this.connectionDefinition), this.transactionSupport, CopyUtil.cloneList(this.authenticationMechanism), this.reauthenticationSupport, CopyUtil.cloneString(this.id), CopyUtil.cloneString(this.transactionSupportId), CopyUtil.cloneString(this.reauthenticationSupportId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticationMechanism == null ? 0 : this.authenticationMechanism.hashCode());
        result = 31 * result + (this.connectionDefinition == null ? 0 : this.connectionDefinition.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.transactionSupport == null ? 0 : this.transactionSupport.hashCode());
        result = 31 * result + (this.reauthenticationSupport ? 1 : 0);
        result = 31 * result + (this.transactionSupportId == null ? 0 : this.transactionSupportId.hashCode());
        result = 31 * result + (this.reauthenticationSupportId == null ? 0 : this.reauthenticationSupportId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundResourceAdapterImpl)) {
            return false;
        }
        OutboundResourceAdapterImpl other = (OutboundResourceAdapterImpl)obj;
        if (this.authenticationMechanism == null ? other.authenticationMechanism != null : !this.authenticationMechanism.equals(other.authenticationMechanism)) {
            return false;
        }
        if (this.connectionDefinition == null ? other.connectionDefinition != null : !this.connectionDefinition.equals(other.connectionDefinition)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.reauthenticationSupport != other.reauthenticationSupport) {
            return false;
        }
        if (this.transactionSupport != other.transactionSupport) {
            return false;
        }
        if (this.transactionSupportId == null ? other.transactionSupportId != null : !this.transactionSupportId.equals(other.transactionSupportId)) {
            return false;
        }
        return !(this.reauthenticationSupportId == null ? other.reauthenticationSupportId != null : !this.reauthenticationSupportId.equals(other.reauthenticationSupportId));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<").append("outbound-resourceadapter");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.connectionDefinition != null) {
            for (ConnectionDefinition cd : this.connectionDefinition) {
                sb.append(cd);
            }
        }
        if (this.transactionSupport != null) {
            sb.append("<").append("transaction-support").append(this.transactionSupportId == null ? "" : " id=\"" + this.transactionSupportId + "\"").append(">");
            sb.append((Object)this.transactionSupport);
            sb.append("</").append("transaction-support").append(">");
        }
        if (this.authenticationMechanism != null) {
            for (AuthenticationMechanism am : this.authenticationMechanism) {
                sb.append(am);
            }
        }
        sb.append("<").append("reauthentication-support").append(this.reauthenticationSupportId == null ? "" : " id=\"" + this.reauthenticationSupportId + "\"").append(">");
        sb.append(this.reauthenticationSupport);
        sb.append("</").append("reauthentication-support").append(">");
        sb.append("</outbound-resourceadapter>");
        return sb.toString();
    }
}

