/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.spec;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.spec.Activationspec;
import org.ironjacamar.common.api.metadata.spec.AdminObject;
import org.ironjacamar.common.api.metadata.spec.AuthenticationMechanism;
import org.ironjacamar.common.api.metadata.spec.ConfigProperty;
import org.ironjacamar.common.api.metadata.spec.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.api.metadata.spec.CredentialInterfaceEnum;
import org.ironjacamar.common.api.metadata.spec.Icon;
import org.ironjacamar.common.api.metadata.spec.InboundResourceAdapter;
import org.ironjacamar.common.api.metadata.spec.LicenseType;
import org.ironjacamar.common.api.metadata.spec.LocalizedXsdString;
import org.ironjacamar.common.api.metadata.spec.MessageListener;
import org.ironjacamar.common.api.metadata.spec.Messageadapter;
import org.ironjacamar.common.api.metadata.spec.OutboundResourceAdapter;
import org.ironjacamar.common.api.metadata.spec.RequiredConfigProperty;
import org.ironjacamar.common.api.metadata.spec.ResourceAdapter;
import org.ironjacamar.common.api.metadata.spec.SecurityPermission;
import org.ironjacamar.common.api.metadata.spec.XsdString;
import org.ironjacamar.common.metadata.MetadataParser;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.AbstractParser;
import org.ironjacamar.common.metadata.spec.ActivationSpecImpl;
import org.ironjacamar.common.metadata.spec.AdminObjectImpl;
import org.ironjacamar.common.metadata.spec.AuthenticationMechanismImpl;
import org.ironjacamar.common.metadata.spec.ConfigPropertyImpl;
import org.ironjacamar.common.metadata.spec.ConnectionDefinitionImpl;
import org.ironjacamar.common.metadata.spec.ConnectorImpl;
import org.ironjacamar.common.metadata.spec.IconImpl;
import org.ironjacamar.common.metadata.spec.InboundResourceAdapterImpl;
import org.ironjacamar.common.metadata.spec.LicenseTypeImpl;
import org.ironjacamar.common.metadata.spec.MessageAdapterImpl;
import org.ironjacamar.common.metadata.spec.MessageListenerImpl;
import org.ironjacamar.common.metadata.spec.OutboundResourceAdapterImpl;
import org.ironjacamar.common.metadata.spec.RequiredConfigPropertyImpl;
import org.ironjacamar.common.metadata.spec.ResourceAdapterImpl;
import org.ironjacamar.common.metadata.spec.SecurityPermissionImpl;
import org.jboss.logging.Messages;

public class RaParser
extends AbstractParser
implements MetadataParser<Connector> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connector parse(XMLStreamReader reader) throws Exception {
        Connector connector = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return connector;
                }
                case 1: {
                    if ("1.7".equals(reader.getAttributeValue(null, "version"))) {
                        switch (reader.getLocalName()) {
                            case "connector": {
                                connector = this.parseConnector17(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.6".equals(reader.getAttributeValue(null, "version"))) {
                        switch (reader.getLocalName()) {
                            case "connector": {
                                connector = this.parseConnector16(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.5".equals(reader.getAttributeValue(null, "version"))) {
                        switch (reader.getLocalName()) {
                            case "connector": {
                                connector = this.parseConnector15(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    switch (reader.getLocalName()) {
                        case "connector": {
                            connector = this.parseConnector10(reader);
                            return connector;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void store(Connector metadata, XMLStreamWriter writer) throws Exception {
        throw new Exception("Not Implemented");
    }

    private Connector parseConnector10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, "id");
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        XsdString specVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("connector".equals(reader.getLocalName())) {
                        icon.trimToSize();
                        description.trimToSize();
                        for (Icon i : icon) {
                            ((IconImpl)i).setLang(null);
                        }
                        for (LocalizedXsdString d : description) {
                            d.setLang(null);
                        }
                        for (LocalizedXsdString n : displayName) {
                            n.setLang(null);
                        }
                        return new ConnectorImpl(Connector.Version.V_10, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayName, icon, id);
                    }
                    switch (reader.getLocalName()) {
                        case "vendor-name": 
                        case "eis-type": 
                        case "license": 
                        case "version": 
                        case "resourceadapter": 
                        case "description": 
                        case "display-name": 
                        case "icon": 
                        case "spec-version": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "vendor-name": {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "eis-type": {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "license": {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case "version": {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "resourceadapter": {
                            resourceadapter = this.parseResourceAdapter10(reader);
                            break block0;
                        }
                        case "description": {
                            if (!description.isEmpty()) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "display-name": {
                            if (!displayName.isEmpty()) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "icon": {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                        case "spec-version": {
                            specVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector15(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, "id");
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("connector".equals(reader.getLocalName())) {
                        return new ConnectorImpl(Connector.Version.V_15, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayName, icon, id);
                    }
                    switch (reader.getLocalName()) {
                        case "vendor-name": 
                        case "eis-type": 
                        case "license": 
                        case "resourceadapter-version": 
                        case "resourceadapter": 
                        case "description": 
                        case "display-name": 
                        case "icon": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "vendor-name": {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "eis-type": {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "license": {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case "resourceadapter-version": {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "resourceadapter": {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "display-name": {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "icon": {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector16(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, "metadata-complete"));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, "id");
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("connector".equals(reader.getLocalName())) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_16, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    switch (reader.getLocalName()) {
                        case "module-name": 
                        case "vendor-name": 
                        case "eis-type": 
                        case "license": 
                        case "resourceadapter-version": 
                        case "resourceadapter": 
                        case "required-work-context": 
                        case "description": 
                        case "display-name": 
                        case "icon": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "module-name": {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "vendor-name": {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "eis-type": {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "license": {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case "resourceadapter-version": {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "resourceadapter": {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case "required-work-context": {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "display-name": {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "icon": {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector17(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, "metadata-complete"));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, "id");
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("connector".equals(reader.getLocalName())) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new ConnectorImpl(Connector.Version.V_17, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    switch (reader.getLocalName()) {
                        case "module-name": 
                        case "vendor-name": 
                        case "eis-type": 
                        case "license": 
                        case "resourceadapter-version": 
                        case "resourceadapter": 
                        case "required-work-context": 
                        case "description": 
                        case "display-name": 
                        case "icon": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "module-name": {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "vendor-name": {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "eis-type": {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "license": {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case "resourceadapter-version": {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "resourceadapter": {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case "required-work-context": {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "display-name": {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "icon": {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Icon parseIcon(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString largeIcon = null;
        XsdString smallIcon = null;
        String id = reader.getAttributeValue(null, "id");
        String lang = reader.getAttributeValue(null, "lang");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("icon".equals(reader.getLocalName())) {
                        return new IconImpl(smallIcon, largeIcon, lang, id);
                    }
                    switch (reader.getLocalName()) {
                        case "small-icon": 
                        case "large-icon": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "small-icon": {
                            smallIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "large-icon": {
                            largeIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString resourceadapterClass = null;
        OutboundResourceAdapter outboundResourceadapter = null;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        InboundResourceAdapter inboundResourceadapter = null;
        ArrayList<AdminObject> adminobject = new ArrayList<AdminObject>();
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("resourceadapter".equals(reader.getLocalName())) {
                        configProperty.trimToSize();
                        securityPermission.trimToSize();
                        adminobject.trimToSize();
                        return new ResourceAdapterImpl(resourceadapterClass, configProperty, outboundResourceadapter, inboundResourceadapter, adminobject, securityPermission, id);
                    }
                    switch (reader.getLocalName()) {
                        case "resourceadapter-class": 
                        case "config-property": 
                        case "outbound-resourceadapter": 
                        case "inbound-resourceadapter": 
                        case "adminobject": 
                        case "security-permission": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "resourceadapter-class": {
                            resourceadapterClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "config-property": {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case "outbound-resourceadapter": {
                            outboundResourceadapter = this.parseOutboundResourceadapter(reader);
                            break block0;
                        }
                        case "inbound-resourceadapter": {
                            inboundResourceadapter = this.parseInboundResourceadapter(reader);
                            break block0;
                        }
                        case "adminobject": {
                            adminobject.add(this.parseAdminObject(reader));
                            break block0;
                        }
                        case "security-permission": {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter parseResourceAdapter10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedConnectionFactoryClass = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>();
        boolean reauthenticationSupport = false;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        String id = reader.getAttributeValue(null, "id");
        String rsId = null;
        String tsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("resourceadapter".equals(reader.getLocalName())) {
                        authenticationMechanism.trimToSize();
                        configProperties.trimToSize();
                        securityPermission.trimToSize();
                        ArrayList<ConnectionDefinition> cds = new ArrayList<ConnectionDefinition>(1);
                        ConnectionDefinitionImpl cd = new ConnectionDefinitionImpl(managedConnectionFactoryClass, configProperties, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass, id);
                        cds.add(cd);
                        OutboundResourceAdapterImpl ora = new OutboundResourceAdapterImpl(cds, transactionSupport, authenticationMechanism, reauthenticationSupport, id, tsId, rsId);
                        return new ResourceAdapterImpl(null, null, ora, null, null, securityPermission, id);
                    }
                    switch (reader.getLocalName()) {
                        case "config-property": 
                        case "authentication-mechanism": 
                        case "managedconnectionfactory-class": 
                        case "connection-interface": 
                        case "connection-impl-class": 
                        case "connectionfactory-interface": 
                        case "connectionfactory-impl-class": 
                        case "reauthentication-support": 
                        case "security-permission": 
                        case "transaction-support": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            configProperties.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case "authentication-mechanism": {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case "managedconnectionfactory-class": {
                            managedConnectionFactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connection-interface": {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connection-impl-class": {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connectionfactory-interface": {
                            connectionFactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connectionfactory-impl-class": {
                            connectionFactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "reauthentication-support": {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                        case "security-permission": {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                        case "transaction-support": {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf(reader.getElementText().trim());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private InboundResourceAdapter parseInboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Messageadapter messageadapter = null;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("inbound-resourceadapter".equals(reader.getLocalName())) {
                        return new InboundResourceAdapterImpl(messageadapter, id);
                    }
                    switch (reader.getLocalName()) {
                        case "messageadapter": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "messageadapter": {
                            messageadapter = this.parseMessageAdapter(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Messageadapter parseMessageAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<MessageListener> messagelistener = new ArrayList<MessageListener>();
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("messageadapter".equals(reader.getLocalName())) {
                        messagelistener.trimToSize();
                        return new MessageAdapterImpl(messagelistener, id);
                    }
                    switch (reader.getLocalName()) {
                        case "messagelistener": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "messagelistener": {
                            messagelistener.add(this.parseMessageListener(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private MessageListener parseMessageListener(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Activationspec activationspec = null;
        XsdString messagelistenerType = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("messagelistener".equals(reader.getLocalName())) {
                        return new MessageListenerImpl(messagelistenerType, activationspec, id);
                    }
                    switch (reader.getLocalName()) {
                        case "messagelistener-type": 
                        case "activationspec": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "messagelistener-type": {
                            messagelistenerType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "activationspec": {
                            activationspec = this.parseActivationspec(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Activationspec parseActivationspec(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<RequiredConfigProperty> requiredConfigProperty = new ArrayList<RequiredConfigProperty>();
        XsdString activationspecClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("activationspec".equals(reader.getLocalName())) {
                        requiredConfigProperty.trimToSize();
                        configProperty.trimToSize();
                        return new ActivationSpecImpl(activationspecClass, requiredConfigProperty, configProperty, id);
                    }
                    switch (reader.getLocalName()) {
                        case "activationspec-class": 
                        case "required-config-property": 
                        case "config-property": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "activationspec-class": {
                            activationspecClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "required-config-property": {
                            requiredConfigProperty.add(this.parseRequiredConfigProperty(reader));
                            break block0;
                        }
                        case "config-property": {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private RequiredConfigProperty parseRequiredConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("required-config-property".equals(reader.getLocalName())) {
                        description.trimToSize();
                        return new RequiredConfigPropertyImpl(description, configPropertyName, id);
                    }
                    switch (reader.getLocalName()) {
                        case "description": 
                        case "config-property-name": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "config-property-name": {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private OutboundResourceAdapter parseOutboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean reauthenticationSupport = false;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<ConnectionDefinition> connectionDefinition = new ArrayList<ConnectionDefinition>();
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        String id = reader.getAttributeValue(null, "id");
        String tsId = null;
        String rsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("outbound-resourceadapter".equals(reader.getLocalName())) {
                        authenticationMechanism.trimToSize();
                        connectionDefinition.trimToSize();
                        return new OutboundResourceAdapterImpl(connectionDefinition, transactionSupport, authenticationMechanism, reauthenticationSupport, id, tsId, rsId);
                    }
                    switch (reader.getLocalName()) {
                        case "connection-definition": 
                        case "authentication-mechanism": 
                        case "transaction-support": 
                        case "reauthentication-support": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "connection-definition": {
                            connectionDefinition.add(this.parseConncetionDefinition(reader));
                            break block0;
                        }
                        case "authentication-mechanism": {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case "transaction-support": {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf(reader.getElementText().trim());
                            break block0;
                        }
                        case "reauthentication-support": {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConnectionDefinition parseConncetionDefinition(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedconnectionfactoryClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryInterface = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("connection-definition".equals(reader.getLocalName())) {
                        configProperty.trimToSize();
                        return new ConnectionDefinitionImpl(managedconnectionfactoryClass, configProperty, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
                    }
                    switch (reader.getLocalName()) {
                        case "config-property": 
                        case "managedconnectionfactory-class": 
                        case "connectionfactory-interface": 
                        case "connectionfactory-impl-class": 
                        case "connection-interface": 
                        case "connection-impl-class": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case "managedconnectionfactory-class": {
                            managedconnectionfactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connectionfactory-interface": {
                            connectionfactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connectionfactory-impl-class": {
                            connectionfactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connection-interface": {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "connection-impl-class": {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AuthenticationMechanism parseAuthenticationMechanism(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString authenticationMechanismType = XsdString.NULL_XSDSTRING;
        CredentialInterfaceEnum credentialInterface = null;
        String cIId = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("authentication-mechanism".equals(reader.getLocalName())) {
                        description.trimToSize();
                        return new AuthenticationMechanismImpl(description, authenticationMechanismType, credentialInterface, id, cIId);
                    }
                    switch (reader.getLocalName()) {
                        case "authentication-mechanism-type": 
                        case "credential-interface": 
                        case "description": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "authentication-mechanism-type": {
                            authenticationMechanismType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "credential-interface": {
                            cIId = reader.getAttributeValue(null, "id");
                            credentialInterface = CredentialInterfaceEnum.forName(reader.getElementText().trim());
                            break block0;
                        }
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AdminObject parseAdminObject(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString adminobjectInterface = XsdString.NULL_XSDSTRING;
        XsdString adminobjectClass = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("adminobject".equals(reader.getLocalName())) {
                        configProperty.trimToSize();
                        return new AdminObjectImpl(adminobjectInterface, adminobjectClass, configProperty, id);
                    }
                    switch (reader.getLocalName()) {
                        case "adminobject-class": 
                        case "adminobject-interface": 
                        case "config-property": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "adminobject-class": {
                            adminobjectClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "adminobject-interface": {
                            adminobjectInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "config-property": {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConfigProperty parseConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString configPropertyType = XsdString.NULL_XSDSTRING;
        XsdString configPropertyValue = XsdString.NULL_XSDSTRING;
        Boolean configPropertyIgnore = null;
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        Boolean configPropertySupportsDynamicUpdates = null;
        Boolean configPropertyConfidential = null;
        String ignoreId = null;
        String updatesId = null;
        String confidId = null;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("config-property".equals(reader.getLocalName())) {
                        description.trimToSize();
                        return new ConfigPropertyImpl(description, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, id, false, null, ignoreId, updatesId, confidId);
                    }
                    switch (reader.getLocalName()) {
                        case "description": 
                        case "config-property-name": 
                        case "config-property-type": 
                        case "config-property-value": 
                        case "config-property-ignore": 
                        case "config-property-confidential": 
                        case "config-property-supports-dynamic-updates": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "config-property-name": {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "config-property-type": {
                            configPropertyType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "config-property-value": {
                            configPropertyValue = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case "config-property-ignore": {
                            ignoreId = reader.getAttributeValue(null, "id");
                            configPropertyIgnore = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                        case "config-property-confidential": {
                            confidId = reader.getAttributeValue(null, "id");
                            configPropertyConfidential = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                        case "config-property-supports-dynamic-updates": {
                            updatesId = reader.getAttributeValue(null, "id");
                            configPropertySupportsDynamicUpdates = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private SecurityPermission parseSecurityPermission(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString securityPermissionSpec = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, "id");
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("security-permission".equals(reader.getLocalName())) {
                        description.trimToSize();
                        return new SecurityPermissionImpl(description, securityPermissionSpec, id);
                    }
                    switch (reader.getLocalName()) {
                        case "description": 
                        case "security-permission-spec": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case "security-permission-spec": {
                            securityPermissionSpec = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private LicenseType parseLicense(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String id = reader.getAttributeValue(null, "id");
        boolean licenseRequired = false;
        String lrid = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("license".equals(reader.getLocalName())) {
                        description.trimToSize();
                        return new LicenseTypeImpl(description, licenseRequired, id, lrid);
                    }
                    switch (reader.getLocalName()) {
                        case "license-required": 
                        case "description": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "license-required": {
                            lrid = reader.getAttributeValue(null, "id");
                            licenseRequired = this.elementAsBoolean(reader, null, null);
                            break block0;
                        }
                        case "description": {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private XsdString elementAsXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        return new XsdString(reader.getElementText().trim(), id, reader.getLocalName());
    }

    private LocalizedXsdString elementAsLocalizedXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        String lang = reader.getAttributeValue(null, "lang");
        return new LocalizedXsdString(reader.getElementText().trim(), id, lang, reader.getLocalName());
    }
}

