/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.spi.annotations.repository;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.logging.Messages;

public class AnnotationScannerFactory {
    private static final String JANDEX = "org.ironjacamar.common.annotations.repository.jandex.AnnotationScannerImpl";
    private static AnnotationScanner defaultImplementation = null;
    private static AnnotationScanner active = null;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public static void registerAnnotationScanner(AnnotationScanner scanner) {
        active = scanner;
    }

    public static AnnotationScanner getAnnotationScanner() {
        if (active != null) {
            return active;
        }
        if (defaultImplementation == null) {
            throw new IllegalStateException(bundle.noAnnotationScanner());
        }
        return defaultImplementation;
    }

    static {
        try {
            Class<?> clz = Class.forName(JANDEX, true, SecurityActions.getClassLoader(AnnotationScannerFactory.class));
            defaultImplementation = (AnnotationScanner)clz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static ClassLoader getClassLoader(final Class<?> c) {
            if (System.getSecurityManager() == null) {
                return c.getClassLoader();
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return c.getClassLoader();
                }
            });
        }
    }
}

