/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.impl.classloader.ArchiveClassLoader;
import com.github.fungal.impl.classloader.ExportClassLoaderRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class ExportClassLoader
extends KernelClassLoader {
    private ExportClassLoaderRepository eclr = new ExportClassLoaderRepository();
    private Set<Integer> classLoaders;

    public ExportClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        if (urls != null) {
            this.classLoaders = this.eclr.register(urls);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name);
        if (result != null) {
            return result;
        }
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                try {
                    result = acl.loadClass(name);
                    if (result == null) continue;
                    return result;
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
        }
        try {
            result = this.eclr.getNonExportClassLoader().loadClass(name);
            if (result != null) {
                return result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.loadClass(name, false);
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null || (resource = acl.getResource(name)) == null) continue;
                return resource;
            }
        }
        if ((resource = this.eclr.getNonExportClassLoader().getResource(name)) != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null || (is = acl.getResourceAsStream(name)) == null) continue;
                return is;
            }
        }
        if ((is = this.eclr.getNonExportClassLoader().getResourceAsStream(name)) != null) {
            return is;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> v = new Vector<URL>();
        Enumeration<URL> e = null;
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null || (e = acl.getResources(name)) == null) continue;
                while (e.hasMoreElements()) {
                    v.add(e.nextElement());
                }
            }
        }
        if ((e = this.eclr.getNonExportClassLoader().getResources(name)) != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        if ((e = super.getResources(name)) != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        return v.elements();
    }

    @Override
    public void clearAssertionStatus() {
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                acl.clearAssertionStatus();
            }
        }
        this.eclr.getNonExportClassLoader().clearAssertionStatus();
        super.clearAssertionStatus();
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                acl.setClassAssertionStatus(className, enabled);
            }
        }
        this.eclr.getNonExportClassLoader().setClassAssertionStatus(className, enabled);
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                acl.setDefaultAssertionStatus(enabled);
            }
        }
        this.eclr.getNonExportClassLoader().setDefaultAssertionStatus(enabled);
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                acl.setPackageAssertionStatus(packageName, enabled);
            }
        }
        this.eclr.getNonExportClassLoader().setPackageAssertionStatus(packageName, enabled);
        super.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> result = null;
        URL[] urls = null;
        if (this.classLoaders != null) {
            for (Integer id : this.classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null || (urls = acl.getURLs()) == null) continue;
                result = new ArrayList(urls.length);
                for (URL u : urls) {
                    result.add(u);
                }
            }
        }
        if ((urls = this.eclr.getNonExportClassLoader().getURLs()) != null) {
            if (result == null) {
                result = new ArrayList<URL>(urls.length);
            }
            for (URL u : urls) {
                result.add(u);
            }
        }
        if ((urls = super.getURLs()) != null) {
            if (result == null) {
                result = new ArrayList(urls.length);
            }
            for (URL u : urls) {
                result.add(u);
            }
        }
        if (result == null) {
            return new URL[0];
        }
        return result.toArray(new URL[result.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[ExportClassLoaderRepository=").append(this.eclr);
        sb.append(", ClassLoaders=").append(this.classLoaders);
        sb.append("]");
        return sb.toString();
    }
}

