/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.remote.commands;

import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import com.github.fungal.impl.HotDeployer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Undeploy
implements Command {
    private static final String NAME = "undeploy";
    private Logger log = Logger.getLogger(Undeploy.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private MainDeployer mainDeployer;
    private HotDeployer hotDeployer;

    public Undeploy(MainDeployer mainDeployer, HotDeployer hotDeployer) {
        this.mainDeployer = mainDeployer;
        this.hotDeployer = hotDeployer;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class[] getParameterTypes() {
        return new Class[]{URL.class};
    }

    @Override
    public Serializable invoke(Serializable[] args) {
        if (args == null || args.length != 1 || !(args[0] instanceof URL)) {
            return new IllegalArgumentException("Unsupported argument list: " + Arrays.toString(args));
        }
        URL url = (URL)args[0];
        try {
            if (this.hotDeployer != null) {
                this.hotDeployer.unregister(url);
            }
            this.mainDeployer.undeploy(url);
            return null;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            sw.write(t.getMessage());
            sw.write(10);
            t.printStackTrace(new PrintWriter(sw));
            return new Exception(sw.toString());
        }
    }

    @Override
    public boolean isPublic() {
        return true;
    }
}

