/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.web;

import com.github.fungal.api.Kernel;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.ironjacamar.web.WARClassLoader;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static void setSystemProperty(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                System.setProperty(name, value);
                return Boolean.TRUE;
            }
        });
    }

    static URLClassLoader createURLCLassLoader(final URL[] urls, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    static WARClassLoader createWARClassLoader(final Kernel kernel, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<WARClassLoader>(){

            @Override
            public WARClassLoader run() {
                return new WARClassLoader(kernel, parent);
            }
        });
    }

    static WebAppClassLoader createWebAppClassLoader(final ClassLoader cl, final WebAppContext wac) {
        return AccessController.doPrivileged(new PrivilegedAction<WebAppClassLoader>(){

            @Override
            public WebAppClassLoader run() {
                try {
                    return new WebAppClassLoader(cl, (WebAppClassLoader.Context)wac);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        });
    }
}

