/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.web;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.ironjacamar.web.SecurityActions;
import org.ironjacamar.web.WARClassLoader;
import org.ironjacamar.web.WARDeployment;
import org.ironjacamar.web.WebServer;
import org.jboss.logging.Logger;

public class WARDeployer
implements Deployer {
    private static Logger log = Logger.getLogger(WARDeployer.class);
    private WebServer webServer = null;

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer server) {
        this.webServer = server;
    }

    public boolean accepts(URL url) {
        return url != null && (url.toExternalForm().endsWith(".war") || url.toExternalForm().endsWith(".war/"));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public synchronized Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying: " + url.toExternalForm()));
        }
        try {
            String path = url.toExternalForm();
            String contextPath = "/";
            if (!path.endsWith("/")) {
                contextPath = contextPath + path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
            } else {
                int lastIndex = path.lastIndexOf(47);
                int index = path.indexOf(47);
                boolean done = false;
                while (!done) {
                    if (index + 1 <= path.length()) {
                        int nextIndex = path.indexOf(47, index + 1);
                        if (nextIndex == lastIndex) {
                            done = true;
                            continue;
                        }
                        index = nextIndex;
                        continue;
                    }
                    done = true;
                }
                contextPath = contextPath + path.substring(index + 1, path.lastIndexOf("."));
            }
            String tmpPath = "/web";
            if ("/ROOT".equalsIgnoreCase(contextPath)) {
                contextPath = "/";
                tmpPath = tmpPath + "/root";
            } else {
                tmpPath = tmpPath + contextPath;
            }
            File tmp = new File(SecurityActions.getSystemProperty("ironjacamar.home"), "/tmp/");
            File tmpDeployment = new File(tmp, tmpPath);
            if (tmpDeployment.exists()) {
                FileUtil fileUtil = new FileUtil();
                fileUtil.delete(tmpDeployment);
            }
            if (!tmpDeployment.mkdirs()) {
                throw new IOException("Unable to create " + tmpDeployment);
            }
            log.debugf("ContextPath=%s", (Object)contextPath);
            log.debugf("TmpPath=%s", (Object)tmpPath);
            WebAppContext webapp = new WebAppContext();
            webapp.setContextPath(contextPath);
            webapp.setWar(url.toString());
            webapp.setTempDirectory(tmpDeployment);
            WARClassLoader webappCL = SecurityActions.createWARClassLoader(context.getKernel(), parent);
            WebAppClassLoader wal = SecurityActions.createWebAppClassLoader(webappCL, webapp);
            if (wal == null) {
                throw new DeployException("WebAppClassLoader is null");
            }
            webapp.setClassLoader((ClassLoader)wal);
            webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
            webapp.setAttribute("org.eclipse.jetty.classInheritanceMap", (Object)new AnnotationConfiguration.ClassInheritanceMap());
            this.webServer.addHandler((Handler)webapp);
            log.info((Object)("Deployed: " + url.toExternalForm()));
            return new WARDeployment(url, (Handler)webapp, tmpDeployment, webappCL);
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new DeployException(t.getMessage(), t);
        }
    }
}

