/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.web;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jetty.server.Handler;
import org.ironjacamar.web.WARDeployer;
import org.jboss.logging.Logger;

public class WARDeployment
implements Deployment {
    private static Logger log = Logger.getLogger(WARDeployer.class);
    private URL archive;
    private Handler handler;
    private File tmpDirectory;
    private ClassLoader cl;

    public WARDeployment(URL archive, Handler handler, File tmpDirectory, ClassLoader cl) {
        this.archive = archive;
        this.handler = handler;
        this.tmpDirectory = tmpDirectory;
        this.cl = cl;
    }

    public URL getURL() {
        return this.archive;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeploying: " + this.archive.toExternalForm()));
        }
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpDirectory != null && this.tmpDirectory.exists()) {
            try {
                FileUtil fu = new FileUtil();
                fu.delete(this.tmpDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.info((Object)("Undeployed: " + this.archive.toExternalForm()));
    }
}

