/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.web;

import com.github.fungal.spi.deployers.DeployerPhases;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.ironjacamar.web.ExecutorThreadPool;
import org.ironjacamar.web.SecurityActions;
import org.jboss.logging.Logger;

public class WebServer
implements DeployerPhases {
    private static Logger log = Logger.getLogger(WebServer.class);
    private static boolean trace = log.isTraceEnabled();
    private Server server;
    private String host;
    private int port;
    private MBeanServer mbeanServer;
    private int acceptQueueSize;
    private ExecutorService executorService;
    private HandlerList handlers;

    public WebServer() {
        SecurityActions.setSystemProperty("org.eclipse.jetty.util.log.class", JavaUtilLog.class.getName());
        Log.setLog((org.eclipse.jetty.util.log.Logger)new JavaUtilLog());
        this.server = null;
        this.host = "localhost";
        this.port = 8080;
        this.mbeanServer = null;
        this.acceptQueueSize = 64;
        this.executorService = null;
        this.handlers = new HandlerList();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMBeanServer(MBeanServer v) {
        this.mbeanServer = v;
    }

    public void setAcceptQueueSize(int v) {
        this.acceptQueueSize = v;
    }

    public void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    public void start() throws Throwable {
        this.stop();
        this.server = this.executorService != null ? new Server((ThreadPool)new ExecutorThreadPool(this.executorService)) : new Server();
        MBeanContainer jmx = new MBeanContainer(this.mbeanServer != null ? this.mbeanServer : ManagementFactory.getPlatformMBeanServer());
        this.server.addBean((Object)jmx);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(this.host);
        connector.setPort(this.port);
        connector.setAcceptQueueSize(this.acceptQueueSize);
        this.server.setConnectors(new Connector[]{connector});
        log.info((Object)("Jetty " + Server.getVersion() + " started"));
    }

    public void stop() throws Throwable {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
            this.handlers = new HandlerList();
            log.info((Object)("Jetty " + Server.getVersion() + " stopped"));
        }
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
        if (this.server != null && !this.server.isRunning() && this.handlers != null && this.handlers.getHandlers() != null && this.handlers.getHandlers().length > 0) {
            try {
                ContextHandlerCollection chc = new ContextHandlerCollection();
                chc.setHandlers(this.handlers.getHandlers());
                this.server.setHandler((Handler)chc);
                this.server.start();
            }
            catch (Exception e) {
                log.error((Object)"Could not start Jetty webserver", (Throwable)e);
            }
        }
    }

    public void preUndeploy() throws Throwable {
    }

    public void postUndeploy() throws Throwable {
    }

    void addHandler(Handler handler) {
        handler.setServer(this.server);
        this.handlers.addHandler(handler);
    }
}

