/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import edu.umd.cs.findbugs.anttask.DataFile;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class MineBugHistoryTask
extends AbstractFindBugsTask {
    private File outputFile;
    private String formatDates;
    private String noTabs;
    private String summary;
    private DataFile inputFile;

    public MineBugHistoryTask() {
        super("edu.umd.cs.findbugs.workflow.MineBugHistory");
        this.setFailOnError(true);
    }

    public DataFile createDataFile() {
        if (this.inputFile != null) {
            throw new BuildException("only one dataFile element is allowed", this.getLocation());
        }
        this.inputFile = new DataFile();
        return this.inputFile;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setInput(String input) {
        this.inputFile = new DataFile();
        this.inputFile.name = input;
    }

    public void setFormatDates(String arg) {
        this.formatDates = arg;
    }

    public void setNoTabs(String arg) {
        this.noTabs = arg;
    }

    public void setSummary(String arg) {
        this.summary = arg;
    }

    private void checkBoolean(String attrVal, String attrName) {
        if (attrVal == null) {
            return;
        }
        if (!(attrVal = attrVal.toLowerCase()).equals("true") && !attrVal.equals("false")) {
            throw new BuildException("attribute " + attrName + " requires boolean value", this.getLocation());
        }
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.inputFile == null) {
            throw new BuildException("inputFile element is required");
        }
        this.checkBoolean(this.formatDates, "formatDates");
        this.checkBoolean(this.noTabs, "noTabs");
        this.checkBoolean(this.summary, "summary");
    }

    public void addBoolOption(String option, String value) {
        if (value != null) {
            this.addArg(option + ":" + value);
        }
    }

    @Override
    protected void configureFindbugsEngine() {
        this.addBoolOption("-formatDates", this.formatDates);
        this.addBoolOption("-noTabs", this.noTabs);
        this.addBoolOption("-summary", this.summary);
        this.addArg(this.inputFile.getName());
        if (this.outputFile != null) {
            this.addArg(this.outputFile.getAbsolutePath());
        }
    }

    @Override
    protected void beforeExecuteJavaProcess() {
        this.log("running mineBugHistory...");
    }

    @Override
    protected void afterExecuteJavaProcess(int rc) {
        if (rc != 0) {
            throw new BuildException("execution of " + this.getTaskName() + " failed");
        }
    }
}

