/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.util;

import com.github.fungal.api.util.SecurityActions;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public class JMX {
    private static final String GET = "get";
    private static final String SET = "set";

    private JMX() {
    }

    public static DynamicMBean createMBean(Object obj) throws SecurityException {
        return JMX.createMBean(obj, "", null, null, null, null);
    }

    public static DynamicMBean createMBean(Object obj, String description) throws SecurityException {
        return JMX.createMBean(obj, description, null, null, null, null);
    }

    public static DynamicMBean createMBean(Object obj, String description, Set<String> writeableAttributes) throws SecurityException {
        return JMX.createMBean(obj, description, writeableAttributes, null, null, null);
    }

    public static DynamicMBean createMBean(Object obj, String description, Set<String> writeableAttributes, Map<String, String> descriptions) throws SecurityException {
        return JMX.createMBean(obj, description, writeableAttributes, descriptions, null, null);
    }

    public static DynamicMBean createMBean(Object obj, String description, Set<String> writeableAttributes, Map<String, String> descriptions, Set<String> excludeAttributes, Set<String> excludeOperations) throws SecurityException {
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        if (obj instanceof DynamicMBean) {
            return (DynamicMBean)obj;
        }
        return new ManagementDelegator(obj, description, writeableAttributes, descriptions, excludeAttributes, excludeOperations);
    }

    static class MBeanOperationComparator
    implements Comparator<MBeanOperationInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(MBeanOperationInfo o1, MBeanOperationInfo o2) {
            int result = o1.getName().compareTo(o2.getName());
            if (result == 0) {
                int p2;
                int p1 = o1.getSignature().length;
                if (p1 < (p2 = o2.getSignature().length)) {
                    return -1;
                }
                if (p1 > p2) {
                    return 1;
                }
                for (int i = 0; i < o1.getSignature().length; ++i) {
                    MBeanParameterInfo pi1 = o1.getSignature()[i];
                    MBeanParameterInfo pi2 = o2.getSignature()[i];
                    result = pi1.getType().compareTo(pi2.getType());
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return obj instanceof MBeanOperationComparator;
        }

        public int hashCode() {
            return 42;
        }
    }

    static class MBeanAttributeComparator
    implements Comparator<MBeanAttributeInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(MBeanAttributeInfo o1, MBeanAttributeInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return obj instanceof MBeanAttributeComparator;
        }

        public int hashCode() {
            return 42;
        }
    }

    static class ManagementDelegator
    implements DynamicMBean {
        private static ConcurrentMap<String, Class<?>> simpleTypes = new ConcurrentHashMap(9);
        private WeakReference<Object> ref;
        private MBeanInfo info;

        public ManagementDelegator(Object instance, String description, Set<String> writeableAttributes, Map<String, String> descriptions, Set<String> excludeAttributes, Set<String> excludeOperations) throws SecurityException {
            Method[] methods;
            Pattern p;
            this.ref = new WeakReference<Object>(instance);
            ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
            HashSet<Pattern> writeableAttributePatterns = null;
            HashSet<Pattern> attributePatterns = null;
            HashSet<Pattern> operationPatterns = null;
            HashMap<String, HashMap<String, Method>> attributeMap = new HashMap<String, HashMap<String, Method>>();
            HashMap<String, HashSet<Method>> operationMap = new HashMap<String, HashSet<Method>>();
            if (writeableAttributes != null) {
                writeableAttributePatterns = new HashSet<Pattern>(writeableAttributes.size());
                for (String pattern : writeableAttributes) {
                    p = Pattern.compile(pattern);
                    writeableAttributePatterns.add(p);
                }
            }
            if (excludeAttributes != null) {
                attributePatterns = new HashSet<Pattern>(excludeAttributes.size());
                for (String pattern : excludeAttributes) {
                    p = Pattern.compile(pattern);
                    attributePatterns.add(p);
                }
            }
            if (excludeOperations != null) {
                operationPatterns = new HashSet<Pattern>(excludeOperations.size());
                for (String pattern : excludeOperations) {
                    p = Pattern.compile(pattern);
                    operationPatterns.add(p);
                }
            }
            for (Method method : methods = SecurityActions.getMethods(instance.getClass())) {
                Pattern p2;
                String s;
                if (method.getDeclaringClass().getName().startsWith("java.")) continue;
                if ((method.getName().startsWith(JMX.GET) || method.getName().startsWith("is")) && method.getParameterTypes().length == 0) {
                    s = method.getName().startsWith(JMX.GET) ? method.getName().substring(3) : method.getName().substring(2);
                    String name = s.substring(0, 1).toUpperCase(Locale.US);
                    if (s.length() > 1) {
                        name = name + s.substring(1);
                    }
                    boolean include = true;
                    if (attributePatterns != null) {
                        Iterator it = attributePatterns.iterator();
                        while (include && it.hasNext()) {
                            p2 = (Pattern)it.next();
                            if (!p2.matcher(name).matches()) continue;
                            include = false;
                        }
                    }
                    if (!include) continue;
                    HashMap<String, Method> m = (HashMap<String, Method>)attributeMap.get(name);
                    if (m == null) {
                        m = new HashMap<String, Method>(2);
                    }
                    m.put(JMX.GET, method);
                    attributeMap.put(name, m);
                    continue;
                }
                if (method.getName().startsWith(JMX.SET) && method.getParameterTypes().length == 1) {
                    s = method.getName().substring(3);
                    String name = s.substring(0, 1).toUpperCase(Locale.US);
                    if (s.length() > 1) {
                        name = name + s.substring(1);
                    }
                    boolean include = true;
                    if (attributePatterns != null) {
                        Iterator it = attributePatterns.iterator();
                        while (include && it.hasNext()) {
                            p2 = (Pattern)it.next();
                            if (!p2.matcher(name).matches()) continue;
                            include = false;
                        }
                    }
                    if (!include || writeableAttributePatterns == null) continue;
                    boolean writeable = false;
                    Iterator it = writeableAttributePatterns.iterator();
                    while (!writeable && it.hasNext()) {
                        Pattern p3 = (Pattern)it.next();
                        if (!p3.matcher(name).matches()) continue;
                        writeable = true;
                    }
                    if (!writeable) continue;
                    HashMap<String, Method> m = (HashMap<String, Method>)attributeMap.get(name);
                    if (m == null) {
                        m = new HashMap<String, Method>(2);
                    }
                    m.put(JMX.SET, method);
                    attributeMap.put(name, m);
                    continue;
                }
                String name = method.getName();
                boolean include = true;
                if (operationPatterns != null) {
                    Iterator it = operationPatterns.iterator();
                    while (include && it.hasNext()) {
                        Pattern p4 = (Pattern)it.next();
                        if (!p4.matcher(name).matches()) continue;
                        include = false;
                    }
                }
                if (!include) continue;
                HashSet<Method> ms = (HashSet<Method>)operationMap.get(name);
                if (ms == null) {
                    ms = new HashSet<Method>();
                }
                ms.add(method);
                operationMap.put(name, ms);
            }
            for (Map.Entry entry : attributeMap.entrySet()) {
                String name = (String)entry.getKey();
                Map m = (Map)entry.getValue();
                Method getMethod = (Method)m.get(JMX.GET);
                Method setMethod = (Method)m.get(JMX.SET);
                try {
                    String desc = "";
                    if (descriptions != null && descriptions.get(name) != null) {
                        desc = descriptions.get(name);
                    }
                    MBeanAttributeInfo mai = new MBeanAttributeInfo(name, desc, getMethod, setMethod);
                    attrs.add(mai);
                }
                catch (Throwable t) {}
            }
            for (Map.Entry entry : operationMap.entrySet()) {
                String name = (String)entry.getKey();
                Set operations = (Set)entry.getValue();
                try {
                    String desc = "";
                    if (descriptions != null && descriptions.get(name) != null) {
                        desc = descriptions.get(name);
                    }
                    for (Method operation : operations) {
                        MBeanParameterInfo[] signature = null;
                        if (operation.getParameterTypes().length > 0) {
                            signature = new MBeanParameterInfo[operation.getParameterTypes().length];
                            for (int i = 0; i < operation.getParameterTypes().length; ++i) {
                                MBeanParameterInfo pi;
                                signature[i] = pi = new MBeanParameterInfo("p" + (i + 1), operation.getParameterTypes()[i].getName(), "");
                            }
                        }
                        MBeanOperationInfo moi = new MBeanOperationInfo(name, desc, signature, operation.getReturnType().getName(), 3);
                        ops.add(moi);
                    }
                }
                catch (Throwable t) {
                }
            }
            if (attrs.size() > 0) {
                Collections.sort(attrs, new MBeanAttributeComparator());
            }
            if (ops.size() > 0) {
                Collections.sort(ops, new MBeanOperationComparator());
            }
            this.info = new MBeanInfo(instance.getClass().getName(), description != null ? description : "", attrs.size() > 0 ? attrs.toArray(new MBeanAttributeInfo[attrs.size()]) : null, null, ops.size() > 0 ? ops.toArray(new MBeanOperationInfo[ops.size()]) : null, null);
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (attribute == null) {
                throw new AttributeNotFoundException("Invalid attribute name: null");
            }
            Object instance = this.ref.get();
            if (instance == null) {
                throw new MBeanException(null, "Instance garbaged collected");
            }
            String name = attribute.substring(0, 1).toUpperCase(Locale.US);
            if (attribute.length() > 1) {
                name = name + attribute.substring(1);
            }
            for (MBeanAttributeInfo mai : this.info.getAttributes()) {
                if (!name.equals(mai.getName())) continue;
                try {
                    Method method = null;
                    method = !mai.isIs() ? SecurityActions.getMethod(instance.getClass(), JMX.GET + name, null) : SecurityActions.getMethod(instance.getClass(), "is" + name, null);
                    SecurityActions.setAccessible(method);
                    return method.invoke(instance, (Object[])null);
                }
                catch (Exception e) {
                    throw new MBeanException(e, "Exception during getAttribute(" + attribute + ")");
                }
            }
            throw new AttributeNotFoundException("Invalid attribute name: " + attribute);
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            if (attributes != null) {
                AttributeList result = new AttributeList();
                for (String attr : attributes) {
                    try {
                        result.add(this.getAttribute(attr));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                return result;
            }
            return null;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return this.info;
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            Object instance = this.ref.get();
            if (instance == null) {
                throw new MBeanException(null, "Instance garbaged collected");
            }
            for (MBeanOperationInfo moi : this.info.getOperations()) {
                if (!actionName.equals(moi.getName())) continue;
                boolean correct = false;
                if (signature == null && moi.getSignature() == null) {
                    correct = true;
                } else if (signature != null && moi.getSignature() != null && signature.length == moi.getSignature().length) {
                    correct = true;
                    for (int i = 0; correct && i < signature.length; ++i) {
                        MBeanParameterInfo mpi = moi.getSignature()[i];
                        if (signature[i].equals(mpi.getType())) continue;
                        correct = false;
                    }
                }
                if (!correct) continue;
                try {
                    Class[] paramTypes = null;
                    if (signature != null && signature.length > 0) {
                        ArrayList l = new ArrayList(signature.length);
                        for (String paramType : signature) {
                            Class<?> clz = (Class<?>)simpleTypes.get(paramType);
                            if (clz == null) {
                                clz = this.resolveClass(paramType, SecurityActions.getClassLoader(instance.getClass()));
                            }
                            l.add(clz);
                        }
                        paramTypes = l.toArray(new Class[l.size()]);
                    }
                    Method method = SecurityActions.getMethod(instance.getClass(), actionName, paramTypes);
                    SecurityActions.setAccessible(method);
                    return method.invoke(instance, params);
                }
                catch (Exception e) {
                    throw new MBeanException(e, "Exception during invoke(" + actionName + ", " + Arrays.toString(params) + ", " + Arrays.toString(signature) + ")");
                }
            }
            return null;
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            if (attribute == null) {
                throw new AttributeNotFoundException("Invalid attribute name: null");
            }
            Object instance = this.ref.get();
            if (instance == null) {
                throw new MBeanException(null, "Instance garbaged collected");
            }
            String name = attribute.getName().substring(0, 1).toUpperCase(Locale.US);
            if (attribute.getName().length() > 1) {
                name = name + attribute.getName().substring(1);
            }
            for (MBeanAttributeInfo mai : this.info.getAttributes()) {
                if (!name.equals(mai.getName())) continue;
                try {
                    Class<?> type = (Class<?>)simpleTypes.get(mai.getType());
                    if (type == null) {
                        type = this.resolveClass(mai.getType(), SecurityActions.getClassLoader(instance.getClass()));
                    }
                    Method method = SecurityActions.getMethod(instance.getClass(), JMX.SET + name, type);
                    SecurityActions.setAccessible(method);
                    method.invoke(instance, attribute.getValue());
                }
                catch (Exception e) {
                    throw new MBeanException(e, "Exception during setAttribute(" + attribute + ")");
                }
            }
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            if (attributes != null) {
                AttributeList result = new AttributeList();
                for (Attribute attr : attributes.asList()) {
                    try {
                        this.setAttribute(attr);
                        result.add(attr);
                    }
                    catch (Throwable t) {}
                }
                return result;
            }
            return null;
        }

        private Class<?> resolveClass(String clzName, ClassLoader cl) throws MBeanException {
            try {
                Class<?> c = Class.forName(clzName, true, cl);
                return c;
            }
            catch (Exception e) {
                try {
                    Class<?> c = Class.forName(clzName, true, SecurityActions.getThreadContextClassLoader());
                    return c;
                }
                catch (Exception e2) {
                    try {
                        Class<?> c = Class.forName(clzName, true, SecurityActions.getClassLoader(JMX.class));
                        return c;
                    }
                    catch (Exception e3) {
                        try {
                            Class<?> c = Class.forName(clzName, true, SecurityActions.getSystemClassLoader());
                            return c;
                        }
                        catch (Exception e4) {
                            throw new MBeanException(e, "Exception during loading class: " + clzName);
                        }
                    }
                }
            }
        }

        static {
            simpleTypes.put(Void.TYPE.getName(), Void.TYPE);
            simpleTypes.put(Byte.TYPE.getName(), Byte.TYPE);
            simpleTypes.put(Short.TYPE.getName(), Short.TYPE);
            simpleTypes.put(Integer.TYPE.getName(), Integer.TYPE);
            simpleTypes.put(Long.TYPE.getName(), Long.TYPE);
            simpleTypes.put(Character.TYPE.getName(), Character.TYPE);
            simpleTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
            simpleTypes.put(Float.TYPE.getName(), Float.TYPE);
            simpleTypes.put(Double.TYPE.getName(), Double.TYPE);
        }
    }
}

