/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.bootstrap;

import com.github.fungal.bootstrap.Bootstrap;
import com.github.fungal.bootstrap.DependenciesType;
import com.github.fungal.bootstrap.DependencyType;
import com.github.fungal.bootstrap.PropertyType;
import com.github.fungal.bootstrap.ProtocolType;
import com.github.fungal.bootstrap.ProtocolsType;
import com.github.fungal.bootstrap.ServerType;
import com.github.fungal.bootstrap.ServersType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Unmarshaller {
    public Bootstrap unmarshal(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        InputStream is = null;
        try {
            Bootstrap bootstrap = new Bootstrap();
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.toURI());
                is = new FileInputStream(file);
            } else if ("jar".equals(url.getProtocol())) {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                is = jarConnection.getInputStream();
            } else {
                throw new IOException("Unsupport protocol: " + url);
            }
            is = new BufferedInputStream(is, 4096);
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            while (xmlStreamReader.hasNext()) {
                int eventCode = xmlStreamReader.next();
                switch (eventCode) {
                    case 1: {
                        if ("url".equals(xmlStreamReader.getLocalName())) {
                            bootstrap.getUrl().add(this.readUrl(xmlStreamReader));
                            break;
                        }
                        if ("protocols".equals(xmlStreamReader.getLocalName())) {
                            bootstrap.setProtocols(this.readProtocols(xmlStreamReader));
                            break;
                        }
                        if ("servers".equals(xmlStreamReader.getLocalName())) {
                            bootstrap.setServers(this.readServers(xmlStreamReader));
                            break;
                        }
                        if (!"dependencies".equals(xmlStreamReader.getLocalName())) break;
                        bootstrap.setDependencies(this.readDependencies(xmlStreamReader));
                        break;
                    }
                }
            }
            Bootstrap bootstrap2 = bootstrap;
            return bootstrap2;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private String readUrl(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String result = null;
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    result = xmlStreamReader.getText();
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"url".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("url tag not completed");
        }
        return result;
    }

    private ProtocolsType readProtocols(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ProtocolsType result = new ProtocolsType();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"protocol".equals(name)) break;
                    result.getProtocol().add(this.readProtocol(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"protocols".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("protocols tag not completed");
        }
        return result;
    }

    private ProtocolType readProtocol(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String name;
        ProtocolType result = new ProtocolType();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            name = xmlStreamReader.getAttributeLocalName(i);
            if ("id".equals(name)) {
                result.setId(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"class-name".equals(name)) continue;
            result.setClassName(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    name = xmlStreamReader.getLocalName();
                    if (!"property".equals(name)) break;
                    result.getProperty().add(this.readProperty(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"protocol".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("protocol tag not completed");
        }
        return result;
    }

    private PropertyType readProperty(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        PropertyType result = new PropertyType();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"name".equals(name)) continue;
            result.setName(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result.setValue(xmlStreamReader.getText().trim());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"property".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("property tag not completed");
        }
        return result;
    }

    private ServersType readServers(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ServersType result = new ServersType();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"server".equals(name)) break;
                    result.getServer().add(this.readServer(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"servers".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("servers tag not completed");
        }
        return result;
    }

    private ServerType readServer(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ServerType result = new ServerType();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("protocol".equals(name)) {
                result.setProtocol(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"pattern".equals(name)) continue;
            result.setPattern(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result.setValue(xmlStreamReader.getText().trim());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"server".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("server tag not completed");
        }
        return result;
    }

    private DependenciesType readDependencies(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        DependenciesType result = new DependenciesType();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"dependency".equals(name)) break;
                    result.getDependency().add(this.readDependency(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"dependencies".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("dependencies tag not completed");
        }
        return result;
    }

    private DependencyType readDependency(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String name;
        DependencyType result = new DependencyType();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            name = xmlStreamReader.getAttributeLocalName(i);
            if (!"target".equals(name)) continue;
            result.setTarget(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    name = xmlStreamReader.getLocalName();
                    if ("organisation".equals(name)) {
                        result.setOrganisation(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("module".equals(name)) {
                        result.setModule(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("artifact".equals(name)) {
                        result.setArtifact(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("revision".equals(name)) {
                        result.setRevision(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("classifier".equals(name)) {
                        result.setClassifier(this.readString(xmlStreamReader));
                        break;
                    }
                    if (!"ext".equals(name)) break;
                    result.setExt(this.readString(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"dependency".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("dependency tag not completed");
        }
        return result;
    }

    private String readString(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String result = null;
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result = xmlStreamReader.getText().trim();
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        return result;
    }
}

