/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.api.deployment.Bean;
import com.github.fungal.api.deployment.Constructor;
import com.github.fungal.api.deployment.Depends;
import com.github.fungal.api.deployment.Entry;
import com.github.fungal.api.deployment.Incallback;
import com.github.fungal.api.deployment.Inject;
import com.github.fungal.api.deployment.Install;
import com.github.fungal.api.deployment.List;
import com.github.fungal.api.deployment.Map;
import com.github.fungal.api.deployment.Null;
import com.github.fungal.api.deployment.Parameter;
import com.github.fungal.api.deployment.Property;
import com.github.fungal.api.deployment.Set;
import com.github.fungal.api.deployment.This;
import com.github.fungal.api.deployment.Uncallback;
import com.github.fungal.api.deployment.Uninstall;
import com.github.fungal.api.deployment.Value;
import com.github.fungal.impl.Callback;
import com.github.fungal.impl.Injection;
import com.github.fungal.impl.KernelImpl;
import com.github.fungal.impl.MainDeployerImpl;
import com.github.fungal.impl.SecurityActions;
import com.github.fungal.impl.ServiceLifecycle;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerPhases;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

class BeanDeployer
implements Runnable {
    private static final java.util.Set<Class<?>> SUPPORTED_TYPES = new HashSet(19);
    private Bean bt;
    private java.util.List<String> beans;
    private java.util.Map<String, java.util.List<Method>> uninstall;
    private java.util.Map<String, String> stops;
    private java.util.Map<String, String> destroys;
    private java.util.Set<String> ignoreStops;
    private java.util.Set<String> ignoreDestroys;
    private KernelImpl kernel;
    private CountDownLatch beansLatch;
    private ClassLoader classLoader;
    private Logger log;
    private DeployException deployException;

    public BeanDeployer(Bean bt, java.util.List<String> beans, java.util.Map<String, java.util.List<Method>> uninstall, java.util.Map<String, String> stops, java.util.Map<String, String> destroys, java.util.Set<String> ignoreStops, java.util.Set<String> ignoreDestroys, KernelImpl kernel, CountDownLatch beansLatch, ClassLoader classLoader, Logger log) {
        this.bt = bt;
        this.beans = beans;
        this.uninstall = uninstall;
        this.stops = stops;
        this.destroys = destroys;
        this.ignoreStops = ignoreStops;
        this.ignoreDestroys = ignoreDestroys;
        this.kernel = kernel;
        this.beansLatch = beansLatch;
        this.classLoader = classLoader;
        this.log = log;
        this.deployException = null;
    }

    @Override
    public void run() {
        block6: {
            SecurityActions.setThreadContextClassLoader(this.classLoader);
            String beanName = this.bt.getName();
            try {
                if (this.kernel.getBean(beanName) == null) {
                    CountDownLatch dependencies = this.getDependencies(this.bt);
                    try {
                        if (dependencies != null) {
                            dependencies.await();
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    this.kernel.setBeanStatus(beanName, ServiceLifecycle.STARTING);
                    Object bean = this.createBean(this.bt, this.classLoader);
                    this.kernel.addBean(beanName, bean);
                    this.beans.add(beanName);
                    this.kernel.setBeanStatus(beanName, ServiceLifecycle.STARTED);
                    break block6;
                }
                this.log.warning("Warning: A service with name " + beanName + " already exists");
            }
            catch (Throwable t) {
                this.deployException = new DeployException("Installing bean " + beanName, t);
                this.kernel.setBeanStatus(beanName, ServiceLifecycle.ERROR);
                this.log.log(Level.SEVERE, "Installing bean " + beanName, t);
            }
        }
        this.beansLatch.countDown();
    }

    public DeployException getDeployException() {
        return this.deployException;
    }

    private CountDownLatch getDependencies(Bean bt) throws DeployException {
        Constructor ct;
        java.util.List<Property> pts;
        HashSet<String> deps = null;
        java.util.List<Depends> dts = bt.getDepends();
        if (dts.size() > 0) {
            deps = new HashSet<String>(dts.size());
            for (Depends dt : dts) {
                deps.add(dt.getValue());
            }
        }
        if ((pts = bt.getProperty()).size() > 0) {
            for (Property pt : pts) {
                Object element = pt.getContent().get(0);
                if (element == null || !(element instanceof Inject)) continue;
                if (deps == null) {
                    deps = new HashSet(1);
                }
                Inject it = (Inject)element;
                deps.add(it.getBean());
            }
        }
        if ((ct = bt.getConstructor()) != null) {
            if (ct.getFactory() != null) {
                if (deps == null) {
                    deps = new HashSet(1);
                }
                deps.add(ct.getFactory().getBean());
            }
            if (ct.getParameter() != null && ct.getParameter().size() > 0) {
                for (Parameter pt : ct.getParameter()) {
                    Object v = pt.getContent().get(0);
                    if (!(v instanceof Inject)) continue;
                    if (deps == null) {
                        deps = new HashSet(1);
                    }
                    Inject it = (Inject)v;
                    deps.add(it.getBean());
                }
            }
        }
        if (deps != null && deps.size() > 0) {
            CountDownLatch cdl = new CountDownLatch(deps.size());
            for (String dependency : deps) {
                ServiceLifecycle dependencyStatus = this.kernel.getBeanStatus(dependency);
                if (dependencyStatus == null && this.kernel.isAllBeansRegistered()) {
                    throw new DeployException("Unknown dependency: " + dependency);
                }
                this.kernel.addBeanDependants(bt.getName(), dependency, cdl);
            }
            return cdl;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object createBean(Bean bt, ClassLoader cl) throws Throwable {
        Method method;
        Method[] methods;
        ArrayList<Method> candidates;
        String methodName;
        Class<?> clz = null;
        Object instance = null;
        if (bt.getClazz() != null && bt.getConstructor() == null) {
            clz = Class.forName(bt.getClazz(), true, cl);
            java.lang.reflect.Constructor<?> con = this.findConstructor(clz, null, cl);
            SecurityActions.setAccessible(con);
            instance = con.newInstance(new Object[0]);
        } else {
            Object[] args;
            Constructor ct = bt.getConstructor();
            Object var6_10 = null;
            Class<?> factoryClass = null;
            if (ct.getFactory() != null) {
                Object object = this.kernel.getBean(ct.getFactory().getBean());
                factoryClass = object.getClass();
            } else {
                String fcs = ct.getFactoryClass();
                if (fcs == null) {
                    fcs = bt.getClazz();
                }
                factoryClass = Class.forName(fcs, true, cl);
            }
            if (ct.getFactoryMethod() == null) {
                if (ct.getParameter() == null || ct.getParameter().size() == 0) {
                    java.lang.reflect.Constructor<?> con = this.findConstructor(factoryClass, null, cl);
                    SecurityActions.setAccessible(con);
                    instance = con.newInstance(new Object[0]);
                    clz = instance.getClass();
                } else {
                    java.lang.reflect.Constructor<?> factoryConstructor = this.findConstructor(factoryClass, ct.getParameter(), cl);
                    args = this.getArguments(ct.getParameter(), factoryConstructor.getParameterTypes(), cl);
                    SecurityActions.setAccessible(factoryConstructor);
                    instance = factoryConstructor.newInstance(args);
                    clz = instance.getClass();
                }
            } else {
                void var6_12;
                Method factoryMethod = this.findMethod(factoryClass, ct.getFactoryMethod(), ct.getParameter(), cl);
                SecurityActions.setAccessible(factoryMethod);
                if (ct.getParameter() == null || ct.getParameter().size() == 0) {
                    instance = factoryMethod.invoke((Object)var6_12, new Object[0]);
                    clz = instance.getClass();
                } else {
                    args = this.getArguments(ct.getParameter(), factoryMethod.getParameterTypes(), cl);
                    instance = factoryMethod.invoke((Object)var6_12, args);
                    clz = instance.getClass();
                }
            }
        }
        if (bt.getProperty() != null) {
            for (Property property : bt.getProperty()) {
                this.setBeanProperty(instance, property, cl);
            }
        }
        if (!bt.isIgnoreCreate()) {
            try {
                methodName = "create";
                if (bt.getCreate() != null && bt.getCreate().getMethod() != null) {
                    methodName = bt.getCreate().getMethod();
                }
                Method method2 = SecurityActions.getMethod(clz, methodName, null);
                SecurityActions.setAccessible(method2);
                method2.invoke(instance, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        if (!bt.isIgnoreStart()) {
            try {
                methodName = "start";
                if (bt.getStart() != null && bt.getStart().getMethod() != null) {
                    methodName = bt.getStart().getMethod();
                }
                Method method3 = SecurityActions.getMethod(clz, methodName, null);
                SecurityActions.setAccessible(method3);
                method3.invoke(instance, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        if (bt.getStop() != null && bt.getStop().getMethod() != null) {
            this.stops.put(bt.getName(), bt.getStop().getMethod());
        }
        if (bt.getDestroy() != null && bt.getDestroy().getMethod() != null) {
            this.destroys.put(bt.getName(), bt.getDestroy().getMethod());
        }
        if (bt.isIgnoreStop()) {
            this.ignoreStops.add(bt.getName());
        }
        if (bt.isIgnoreDestroy()) {
            this.ignoreDestroys.add(bt.getName());
        }
        if (bt.getInstall() != null && bt.getInstall().size() > 0) {
            for (Install install : bt.getInstall()) {
                try {
                    Method method2 = SecurityActions.getMethod(clz, install.getMethod(), null);
                    SecurityActions.setAccessible(method2);
                    method2.invoke(instance, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
        }
        if (bt.getUninstall() != null && bt.getUninstall().size() > 0) {
            ArrayList<Method> methods2 = new ArrayList<Method>(bt.getUninstall().size());
            for (Uninstall ut : bt.getUninstall()) {
                try {
                    Method method3 = SecurityActions.getMethod(clz, ut.getMethod(), null);
                    SecurityActions.setAccessible(method3);
                    methods2.add(method3);
                }
                catch (NoSuchMethodException nsme) {
                    throw new Exception("Unknown uninstall method:" + ut.getMethod());
                }
            }
            this.uninstall.put(bt.getName(), methods2);
        }
        if (bt.getIncallback() != null && bt.getIncallback().size() > 0) {
            for (Incallback incallback : bt.getIncallback()) {
                candidates = new ArrayList<Method>(1);
                for (Method m : methods = SecurityActions.getMethods(clz)) {
                    if (!m.getName().equals(incallback.getMethod()) || m.getParameterTypes().length != 1) continue;
                    candidates.add(m);
                }
                if (candidates.size() <= 0) continue;
                method = (Method)candidates.get(0);
                SecurityActions.setAccessible(method);
                Class<?> parameter = method.getParameterTypes()[0];
                Callback cb = new Callback(parameter, method, instance);
                this.kernel.registerIncallback(cb);
            }
        }
        if (bt.getUncallback() != null && bt.getUncallback().size() > 0) {
            for (Uncallback uncallback : bt.getUncallback()) {
                candidates = new ArrayList(1);
                for (Method m : methods = SecurityActions.getMethods(clz)) {
                    if (!m.getName().equals(uncallback.getMethod()) || m.getParameterTypes().length != 1) continue;
                    candidates.add(m);
                }
                if (candidates.size() <= 0) continue;
                method = (Method)candidates.get(0);
                SecurityActions.setAccessible(method);
                Class<?> parameter = method.getParameterTypes()[0];
                Callback cb = new Callback(parameter, method, instance);
                this.kernel.registerUncallback(cb);
            }
        }
        if (instance instanceof Deployer) {
            ((MainDeployerImpl)this.kernel.getMainDeployer()).addDeployer((Deployer)instance);
        }
        if (instance instanceof DeployerPhases) {
            this.kernel.addDeployerPhasesBean(bt.getName());
        }
        return instance;
    }

    private java.lang.reflect.Constructor<?> findConstructor(Class<?> clz, java.util.List<Parameter> parameters, ClassLoader cl) throws Throwable {
        if (parameters == null || parameters.size() == 0) {
            for (Class<?> constructorClass = clz; constructorClass != null; constructorClass = constructorClass.getSuperclass()) {
                java.lang.reflect.Constructor<?>[] constructors = SecurityActions.getDeclaredConstructors(constructorClass);
                if (constructors == null) continue;
                for (int i = 0; i < constructors.length; ++i) {
                    java.lang.reflect.Constructor<?> con = constructors[i];
                    if (con.getParameterTypes().length != 0) continue;
                    return con;
                }
            }
        } else {
            for (Class<?> constructorClass = clz; constructorClass != null; constructorClass = constructorClass.getSuperclass()) {
                java.lang.reflect.Constructor<?>[] constructors;
                for (java.lang.reflect.Constructor<?> c : constructors = SecurityActions.getDeclaredConstructors(constructorClass)) {
                    if (parameters.size() != c.getParameterTypes().length) continue;
                    boolean include = true;
                    for (int i = 0; include && i < parameters.size(); ++i) {
                        Parameter pt = parameters.get(i);
                        Class<?> parameterClass = c.getParameterTypes()[i];
                        if (pt.getClazz() == null) {
                            if (pt.getContent().get(0) instanceof Inject || pt.getContent().get(0) instanceof Null || SUPPORTED_TYPES.contains(parameterClass)) continue;
                            include = false;
                            continue;
                        }
                        Class<?> pClz = Class.forName(pt.getClazz(), true, cl);
                        if (parameterClass.equals(pClz)) continue;
                        include = false;
                    }
                    if (!include) continue;
                    return c;
                }
            }
        }
        throw new Exception("Unable to find constructor for " + clz.getName());
    }

    private Method findMethod(Class<?> clz, String name, java.util.List<Parameter> parameters, ClassLoader cl) throws Throwable {
        if (parameters == null || parameters.size() == 0) {
            for (Class<?> methodClass = clz; methodClass != null; methodClass = methodClass.getSuperclass()) {
                Method[] methods = SecurityActions.getDeclaredMethods(methodClass);
                if (methods == null) continue;
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!name.equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                    return method;
                }
            }
        } else {
            for (Class<?> methodClass = clz; methodClass != null; methodClass = methodClass.getSuperclass()) {
                Method[] methods;
                for (Method m : methods = SecurityActions.getDeclaredMethods(methodClass)) {
                    if (!m.getName().equals(name) || parameters.size() != m.getParameterTypes().length) continue;
                    boolean include = true;
                    for (int i = 0; include && i < parameters.size(); ++i) {
                        Parameter pt = parameters.get(i);
                        Class<?> parameterClass = m.getParameterTypes()[i];
                        if (pt.getClazz() == null) {
                            if (pt.getContent().get(0) instanceof Inject || pt.getContent().get(0) instanceof Null || SUPPORTED_TYPES.contains(parameterClass)) continue;
                            include = false;
                            continue;
                        }
                        Class<?> pClz = Class.forName(pt.getClazz(), true, cl);
                        if (parameterClass.equals(pClz)) continue;
                        include = false;
                    }
                    if (!include) continue;
                    return m;
                }
            }
        }
        throw new Exception("Unable to find method (" + name + "[" + parameters + "]) in " + clz.getName());
    }

    private Object[] getArguments(java.util.List<Parameter> definitions, Class<?>[] types, ClassLoader cl) throws Throwable {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        Object[] args = new Object[types.length];
        Injection injection = new Injection();
        for (int i = 0; i < definitions.size(); ++i) {
            Parameter parameter = definitions.get(i);
            Object v = parameter.getContent().get(0);
            args[i] = v instanceof Inject ? this.getInjectValue((Inject)v) : (v instanceof Null ? null : injection.getValue(parameter.toString(), types[i], (String)v, cl));
        }
        return args;
    }

    private Object getInjectValue(Inject it) throws Exception {
        Object injectionObject = this.kernel.getBean(it.getBean());
        if (injectionObject == null) {
            throw new Exception("Required dependency " + it.getBean() + " not found");
        }
        if (it.getProperty() != null) {
            Method method = null;
            Field field = null;
            String baseName = it.getProperty().substring(0, 1).toUpperCase(Locale.US);
            if (it.getProperty().length() > 1) {
                baseName = baseName + it.getProperty().substring(1);
            }
            try {
                String getMethodName = "get" + baseName;
                method = SecurityActions.getMethod(injectionObject.getClass(), getMethodName, null);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    String isMethodName = "is" + baseName;
                    method = SecurityActions.getMethod(injectionObject.getClass(), isMethodName, null);
                }
                catch (NoSuchMethodException insme) {
                    field = SecurityActions.getField(injectionObject.getClass(), it.getProperty());
                }
            }
            if (method != null) {
                SecurityActions.setAccessible(method);
                return method.invoke(injectionObject, new Object[0]);
            }
            SecurityActions.setAccessible(field);
            return field.get(injectionObject);
        }
        return injectionObject;
    }

    private void setBeanProperty(Object instance, Property pt, ClassLoader cl) throws Exception {
        Method m;
        Injection injection = new Injection();
        String name = "set" + pt.getName().substring(0, 1).toUpperCase(Locale.US);
        if (pt.getName().length() > 1) {
            name = name + pt.getName().substring(1);
        }
        if ((m = injection.findMethod(instance.getClass(), name, pt.getClazz())) == null) {
            throw new Exception("Property " + pt.getName() + " not found on " + instance.getClass().getName());
        }
        SecurityActions.setAccessible(m);
        Class<?> parameterClass = m.getParameterTypes()[0];
        Object parameterValue = null;
        Object element = pt.getContent().get(0);
        if (element == null) {
            element = "";
        }
        if (element instanceof Inject) {
            parameterValue = this.getInjectValue((Inject)element);
        } else if (element instanceof Map) {
            Map mt = (Map)element;
            java.util.Map<Object, Object> map = null;
            if (mt.getClazz() == null) {
                map = new HashMap(mt.getEntry().size());
            } else {
                Class<?> mapClass = Class.forName(mt.getClazz(), true, cl);
                if (mt.getClazz().equals("java.util.HashMap") || mt.getClazz().equals("java.util.Hashtable") || mt.getClazz().equals("java.util.LinkedHashMap") || mt.getClazz().equals("java.util.WeakHashMap")) {
                    java.lang.reflect.Constructor<?> con = SecurityActions.getConstructor(mapClass, Integer.TYPE);
                    SecurityActions.setAccessible(con);
                    map = (java.util.Map)con.newInstance(mt.getEntry().size());
                } else {
                    map = (java.util.Map)mapClass.newInstance();
                }
            }
            Class<?> keyClass = Class.forName(mt.getKeyClass(), true, cl);
            Class<?> valueClass = Class.forName(mt.getValueClass(), true, cl);
            for (Entry et : mt.getEntry()) {
                Object key = injection.getValue(et.toString(), keyClass, et.getKey().getValue(), cl);
                Object value = injection.getValue(et.toString(), valueClass, et.getValue().getValue(), cl);
                map.put(key, value);
            }
            parameterValue = map;
        } else if (element instanceof List) {
            List lt = (List)element;
            java.util.List list = null;
            if (lt.getClazz() == null) {
                list = new ArrayList(lt.getValue().size());
            } else {
                Class<?> listClass = Class.forName(lt.getClazz(), true, cl);
                if (lt.getClazz().equals("java.util.ArrayList") || lt.getClazz().equals("java.util.Vector")) {
                    java.lang.reflect.Constructor<?> con = SecurityActions.getConstructor(listClass, Integer.TYPE);
                    SecurityActions.setAccessible(con);
                    list = (java.util.List)con.newInstance(lt.getValue().size());
                } else {
                    list = (java.util.List)listClass.newInstance();
                }
            }
            Class<?> elementClass = Class.forName(lt.getElementClass(), true, cl);
            for (Value vt : lt.getValue()) {
                Object value = injection.getValue(vt.toString(), elementClass, vt.getValue(), cl);
                list.add(value);
            }
            parameterValue = list;
        } else if (element instanceof Set) {
            Set st = (Set)element;
            java.util.Set set = null;
            if (st.getClazz() == null) {
                set = new HashSet(st.getValue().size());
            } else {
                Class<?> setClass = Class.forName(st.getClazz(), true, cl);
                if (st.getClazz().equals("java.util.HashSet")) {
                    java.lang.reflect.Constructor<?> con = SecurityActions.getConstructor(setClass, Integer.TYPE);
                    SecurityActions.setAccessible(con);
                    set = (java.util.Set)con.newInstance(st.getValue().size());
                } else {
                    set = (java.util.Set)setClass.newInstance();
                }
            }
            Class<?> elementClass = Class.forName(st.getElementClass(), true, cl);
            for (Value vt : st.getValue()) {
                Object value = injection.getValue(vt.toString(), elementClass, vt.getValue(), cl);
                set.add(value);
            }
            parameterValue = set;
        } else {
            parameterValue = element instanceof Null ? null : (element instanceof This ? instance : (element instanceof Value ? injection.getValue(pt.getName(), parameterClass, ((Value)element).getValue(), cl) : injection.getValue(pt.getName(), parameterClass, (String)element, cl)));
        }
        m.invoke(instance, parameterValue);
    }

    static {
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(Byte.TYPE);
        SUPPORTED_TYPES.add(Byte.class);
        SUPPORTED_TYPES.add(Short.TYPE);
        SUPPORTED_TYPES.add(Short.class);
        SUPPORTED_TYPES.add(Integer.TYPE);
        SUPPORTED_TYPES.add(Integer.class);
        SUPPORTED_TYPES.add(Long.TYPE);
        SUPPORTED_TYPES.add(Long.class);
        SUPPORTED_TYPES.add(Float.TYPE);
        SUPPORTED_TYPES.add(Float.class);
        SUPPORTED_TYPES.add(Double.TYPE);
        SUPPORTED_TYPES.add(Double.class);
        SUPPORTED_TYPES.add(Boolean.TYPE);
        SUPPORTED_TYPES.add(Boolean.class);
        SUPPORTED_TYPES.add(Character.TYPE);
        SUPPORTED_TYPES.add(Character.class);
        SUPPORTED_TYPES.add(InetAddress.class);
        SUPPORTED_TYPES.add(Class.class);
    }
}

