/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.configuration.KernelConfiguration;
import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.deployment.Bean;
import com.github.fungal.api.deployment.BeanDeployment;
import com.github.fungal.api.events.Event;
import com.github.fungal.api.events.EventListener;
import com.github.fungal.api.remote.Command;
import com.github.fungal.api.util.JMX;
import com.github.fungal.bootstrap.Bootstrap;
import com.github.fungal.bootstrap.Unmarshaller;
import com.github.fungal.impl.BeanDeployer;
import com.github.fungal.impl.BeanDeploymentImpl;
import com.github.fungal.impl.Callback;
import com.github.fungal.impl.Deployers;
import com.github.fungal.impl.DeploymentDeployer;
import com.github.fungal.impl.FungalThreadFactory;
import com.github.fungal.impl.HotDeployer;
import com.github.fungal.impl.JmxRemote;
import com.github.fungal.impl.KernelImplMBean;
import com.github.fungal.impl.MainDeployerImpl;
import com.github.fungal.impl.SecurityActions;
import com.github.fungal.impl.ServiceLifecycle;
import com.github.fungal.impl.netboot.Netboot;
import com.github.fungal.impl.remote.CommunicationServer;
import com.github.fungal.impl.remote.CommunicatorImpl;
import com.github.fungal.impl.remote.commands.Deploy;
import com.github.fungal.impl.remote.commands.GetCommand;
import com.github.fungal.impl.remote.commands.Help;
import com.github.fungal.impl.remote.commands.Undeploy;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class KernelImpl
implements Kernel,
KernelImplMBean {
    private static final String VERSION = "Fungal 0.11.0.Final";
    private KernelConfiguration kernelConfiguration;
    private Logger log = null;
    private boolean trace = false;
    private List<Deployment> deployments = Collections.synchronizedList(new ArrayList(1));
    private ConcurrentMap<String, Object> beans = new ConcurrentHashMap<String, Object>(1);
    private ConcurrentMap<String, ServiceLifecycle> beanStatus = new ConcurrentHashMap<String, ServiceLifecycle>(1);
    private ConcurrentMap<String, Set<String>> beanDependants = new ConcurrentHashMap<String, Set<String>>(1);
    private Map<String, List<CountDownLatch>> beanLatches = Collections.synchronizedMap(new HashMap(1));
    private AtomicInteger beanDeployments;
    private ThreadPoolExecutor threadPoolExecutor;
    private ClassLoader oldClassLoader;
    private KernelClassLoader kernelClassLoader;
    private MainDeployerImpl mainDeployer;
    private MBeanServer mbeanServer;
    private CommunicationServer remote;
    private boolean temporaryEnvironment;
    private ConcurrentMap<Class<?>, List<Callback>> incallbacks = new ConcurrentHashMap(1);
    private ConcurrentMap<Class<?>, List<Callback>> uncallbacks = new ConcurrentHashMap(1);
    private ConcurrentMap<Object, List<Callback>> callbackBeans = new ConcurrentHashMap<Object, List<Callback>>(1);
    private Set<String> deployerPhasesBeans = Collections.synchronizedSet(new HashSet(1));
    private Set<String> newDeployerPhasesBeans = Collections.synchronizedSet(new HashSet(1));
    private HotDeployer hotDeployer;
    private JmxRemote jmxRemote;
    private boolean started;

    public KernelImpl(KernelConfiguration kc) {
        this.kernelConfiguration = kc;
        this.initialize();
    }

    private void initialize() {
        this.log = null;
        this.trace = false;
        this.deployments.clear();
        this.beans.clear();
        this.beanStatus.clear();
        this.beanDependants.clear();
        this.beanLatches.clear();
        this.beanDeployments = new AtomicInteger(0);
        this.setExecutorService(null);
        this.oldClassLoader = null;
        this.kernelClassLoader = null;
        this.mainDeployer = null;
        this.mbeanServer = null;
        this.remote = null;
        this.temporaryEnvironment = false;
        this.incallbacks.clear();
        this.uncallbacks.clear();
        this.callbackBeans.clear();
        this.deployerPhasesBeans.clear();
        this.newDeployerPhasesBeans.clear();
        this.hotDeployer = null;
        this.jmxRemote = null;
        this.started = false;
    }

    @Override
    public String getName() {
        if (this.kernelConfiguration == null) {
            return null;
        }
        return this.kernelConfiguration.getName();
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public Collection<Deployment> getDeployments() {
        ArrayList<Deployment> result = null;
        if (this.deployments != null) {
            result = new ArrayList<Deployment>(this.deployments.size());
            result.addAll(this.deployments);
        }
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public List<Deployment> getDeployments(URL url) {
        return this.getDeployments(url, true);
    }

    List<Deployment> getDeployments(URL url, boolean readonly) {
        ArrayList<Deployment> result = null;
        if (this.deployments != null) {
            if (url == null) {
                for (Deployment deployment : this.deployments) {
                    if (deployment.getURL() != null) continue;
                    if (result == null) {
                        result = new ArrayList<Deployment>(1);
                    }
                    result.add(deployment);
                }
            } else {
                for (Deployment deployment : this.deployments) {
                    if (deployment.getURL() == null || !deployment.getURL().toString().equals(url.toString())) continue;
                    if (result == null) {
                        result = new ArrayList(1);
                    }
                    result.add(deployment);
                }
            }
        }
        if (result == null) {
            return null;
        }
        if (readonly) {
            return Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public void startup() throws Throwable {
        URL u;
        ArrayList<URL> l;
        File[] files;
        File bootstrapXml;
        ThreadGroup tg;
        List<EventListener> els = this.kernelConfiguration.getEventListeners();
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.STARTING);
            }
        }
        if ((tg = this.kernelConfiguration.getThreadGroup()) == null) {
            tg = new ThreadGroup("fungal");
        }
        SynchronousQueue<Runnable> threadPoolQueue = new SynchronousQueue<Runnable>(true);
        FungalThreadFactory tf = new FungalThreadFactory(tg);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, threadPoolQueue, tf);
        tpe.allowCoreThreadTimeOut(true);
        tpe.prestartAllCoreThreads();
        this.setExecutorService(tpe);
        File root = null;
        if (this.kernelConfiguration.getHome() != null) {
            root = new File(this.kernelConfiguration.getHome().toURI());
            SecurityActions.setSystemProperty(this.kernelConfiguration.getName() + ".home", root.getAbsolutePath());
        } else {
            File tmp = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
            root = new File(tmp, this.kernelConfiguration.getName());
            if (root.exists()) {
                this.recursiveDelete(root);
            }
            if (!root.mkdirs()) {
                throw new IOException("Could not create directory " + root.getAbsolutePath());
            }
            SecurityActions.setSystemProperty(this.kernelConfiguration.getName() + ".home", root.getAbsolutePath());
            this.temporaryEnvironment = true;
        }
        File libDirectory = null;
        File configDirectory = null;
        File repositoryDirectory = null;
        File systemDirectory = null;
        File deployDirectory = null;
        if (root != null && root.exists()) {
            if (this.kernelConfiguration.getLibrary() != null) {
                libDirectory = new File(root, File.separator + this.kernelConfiguration.getLibrary() + File.separator);
            }
            if (this.kernelConfiguration.getConfiguration() != null) {
                configDirectory = new File(root, File.separator + this.kernelConfiguration.getConfiguration() + File.separator);
            }
            if (this.kernelConfiguration.getRepository() != null) {
                repositoryDirectory = new File(root, File.separator + this.kernelConfiguration.getRepository() + File.separator);
            }
            if (this.kernelConfiguration.getSystem() != null) {
                systemDirectory = new File(root, File.separator + this.kernelConfiguration.getSystem() + File.separator);
            }
            if (this.kernelConfiguration.getDeploy() != null) {
                deployDirectory = new File(root, File.separator + this.kernelConfiguration.getDeploy() + File.separator);
            }
        }
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.PRE_CLASSLOADER);
            }
        }
        this.oldClassLoader = SecurityActions.getThreadContextClassLoader();
        Bootstrap bootstrap = null;
        if (configDirectory != null && configDirectory.exists() && configDirectory.isDirectory() && (bootstrapXml = new File(configDirectory, "bootstrap.xml")) != null && bootstrapXml.exists()) {
            Unmarshaller bootstrapU = new Unmarshaller();
            bootstrap = bootstrapU.unmarshal(bootstrapXml.toURI().toURL());
        }
        URL[] libUrls = this.getUrls(libDirectory);
        URL[] confUrls = this.getUrls(configDirectory);
        URL[] urls = this.mergeUrls(libUrls, confUrls);
        this.kernelClassLoader = ClassLoaderFactory.create(this.kernelConfiguration.getClassLoader(), urls, this.oldClassLoader);
        SecurityActions.setThreadContextClassLoader(this.kernelClassLoader);
        this.initKernelLogging();
        boolean netbooted = false;
        if (bootstrap != null) {
            netbooted = Netboot.resolve(this.getExecutorService(), bootstrap, repositoryDirectory, root);
        }
        if (netbooted) {
            libUrls = this.getUrls(libDirectory);
            confUrls = this.getUrls(configDirectory);
            urls = this.mergeUrls(libUrls, confUrls);
            this.kernelClassLoader = ClassLoaderFactory.create(this.kernelConfiguration.getClassLoader(), urls, this.kernelClassLoader);
            SecurityActions.setThreadContextClassLoader(this.kernelClassLoader);
        }
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.POST_CLASSLOADER);
            }
        }
        if (this.kernelConfiguration.getBindAddress() != null) {
            SecurityActions.setSystemProperty(this.kernelConfiguration.getName() + ".bindaddress", this.kernelConfiguration.getBindAddress().trim());
        }
        if (this.kernelConfiguration.isManagement()) {
            this.mbeanServer = !this.kernelConfiguration.isUsePlatformMBeanServer() ? MBeanServerFactory.createMBeanServer(this.kernelConfiguration.getName()) : ManagementFactory.getPlatformMBeanServer();
        }
        this.mainDeployer = new MainDeployerImpl(this, new Deployers());
        if (this.kernelConfiguration.isManagement()) {
            ObjectName mainDeployerObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=MainDeployer");
            this.mbeanServer.registerMBean(this.mainDeployer, mainDeployerObjectName);
        }
        this.mainDeployer.addDeployer(new DeploymentDeployer(this));
        this.addBean("Kernel", this, false);
        this.setBeanStatus("Kernel", ServiceLifecycle.STARTED);
        if (this.kernelConfiguration.isManagement()) {
            ObjectName kernelObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=Kernel");
            this.mbeanServer.registerMBean(this, kernelObjectName);
        }
        if (deployDirectory != null && deployDirectory.exists() && deployDirectory.isDirectory() && this.kernelConfiguration.isHotDeployment()) {
            this.hotDeployer = new HotDeployer(this.kernelConfiguration.getHotDeploymentInterval(), deployDirectory, this);
            if (this.kernelConfiguration.isManagement()) {
                ObjectName hotDeployerObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=HotDeployer");
                this.mbeanServer.registerMBean(this.hotDeployer, hotDeployerObjectName);
            }
        }
        if (this.kernelConfiguration.isRemoteAccess()) {
            this.remote = new CommunicationServer(this, this.kernelConfiguration.getBindAddress(), this.kernelConfiguration.getRemotePort());
            this.remote.registerCommand(new Help(this.remote));
            this.remote.registerCommand(new GetCommand(this.remote));
            this.remote.registerCommand(new Deploy(this.getMainDeployer(), this.getHotDeployer()));
            this.remote.registerCommand(new Undeploy(this.getMainDeployer(), this.getHotDeployer()));
            List<Command> commands = this.kernelConfiguration.getCommands();
            if (commands != null && commands.size() > 0) {
                for (Command command : commands) {
                    this.remote.registerCommand(command);
                }
            }
            this.addBean("Communicator", new CommunicatorImpl(this.remote), false);
            this.setBeanStatus("Communicator", ServiceLifecycle.STARTED);
        }
        this.log.info("Fungal 0.11.0.Final started");
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder vmArgs = new StringBuilder();
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            List<String> inputArguments = runtime.getInputArguments();
            Iterator<String> it = inputArguments.iterator();
            while (it.hasNext()) {
                String arg = it.next();
                vmArgs = vmArgs.append(arg);
                if (!it.hasNext()) continue;
                vmArgs = vmArgs.append(" ");
            }
            this.log.fine("Java version: " + SecurityActions.getSystemProperty("java.version") + "," + SecurityActions.getSystemProperty("java.vendor"));
            this.log.fine("Java Runtime: " + SecurityActions.getSystemProperty("java.runtime.name") + " (build " + SecurityActions.getSystemProperty("java.runtime.version") + ")");
            this.log.fine("Java VM: " + SecurityActions.getSystemProperty("java.vm.name") + " " + SecurityActions.getSystemProperty("java.vm.version") + "," + SecurityActions.getSystemProperty("java.vm.vendor"));
            this.log.fine("OS-System: " + SecurityActions.getSystemProperty("os.name") + " " + SecurityActions.getSystemProperty("os.version") + "," + SecurityActions.getSystemProperty("os.arch"));
            this.log.fine("VM arguments: " + vmArgs.toString());
        }
        if (bootstrap != null) {
            this.beanDeployments = new AtomicInteger(bootstrap.getUrl().size());
            ArrayList<URL> bootstrapUrls = new ArrayList<URL>(bootstrap.getUrl().size());
            for (String url : bootstrap.getUrl()) {
                URL fullPath = new URL(configDirectory.toURI().toURL().toExternalForm() + url);
                bootstrapUrls.add(fullPath);
            }
            this.deployUrls(bootstrapUrls.toArray(new URL[bootstrapUrls.size()]));
        }
        this.incallback();
        this.preDeploy(false);
        if (systemDirectory != null && systemDirectory.exists() && systemDirectory.isDirectory() && (files = systemDirectory.listFiles()) != null) {
            l = new ArrayList<URL>(files.length);
            int counter = 0;
            for (File f : files) {
                u = f.toURI().toURL();
                l.add(u);
                if (!u.toString().endsWith(".xml")) continue;
                ++counter;
            }
            Collections.sort(l, this.kernelConfiguration.getDeploymentOrder());
            this.log.log(Level.FINE, "System deployments: " + l);
            this.beanDeployments = new AtomicInteger(counter);
            if (this.kernelConfiguration.isParallelDeploy()) {
                this.deployUrls(l.toArray(new URL[l.size()]));
            } else {
                for (URL u2 : l) {
                    this.deployUrls(new URL[]{u2});
                }
            }
            if (counter > 0) {
                this.incallback();
            }
        }
        if (deployDirectory != null && deployDirectory.exists() && deployDirectory.isDirectory() && (files = deployDirectory.listFiles()) != null) {
            l = new ArrayList(files.length);
            int counter = 0;
            for (File f : files) {
                u = f.toURI().toURL();
                l.add(u);
                if (u.toString().endsWith(".xml")) {
                    ++counter;
                }
                if (this.hotDeployer == null) continue;
                this.hotDeployer.register(u);
            }
            Collections.sort(l, this.kernelConfiguration.getDeploymentOrder());
            this.log.log(Level.FINE, "Deploy deployments: " + l);
            this.beanDeployments = new AtomicInteger(counter);
            if (this.kernelConfiguration.isParallelDeploy()) {
                this.deployUrls(l.toArray(new URL[l.size()]));
            } else {
                for (URL u3 : l) {
                    this.deployUrls(new URL[]{u3});
                }
            }
            if (counter > 0) {
                this.incallback();
            }
        }
        this.postDeploy(false);
        if (this.hotDeployer != null) {
            this.hotDeployer.start();
        }
        if (this.kernelConfiguration.isRemoteAccess()) {
            this.remote.start();
            this.getExecutorService().submit(this.remote);
        }
        if (this.kernelConfiguration.isManagement() && this.kernelConfiguration.isRemoteJmxAccess() && this.kernelConfiguration.getBindAddress() != null) {
            this.jmxRemote = new JmxRemote(this.mbeanServer, this.kernelConfiguration.getBindAddress(), this.kernelConfiguration.getRmiRegistryPort(), this.kernelConfiguration.getRmiServerPort());
            this.jmxRemote.start();
        }
        if (this.log.isLoggable(Level.FINE)) {
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            this.log.fine("Heap memory: " + memoryBean.getHeapMemoryUsage().toString());
            this.log.fine("NonHeap memory: " + memoryBean.getNonHeapMemoryUsage().toString());
        }
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.STARTED);
            }
        }
        this.started = true;
    }

    private void initKernelLogging() {
        this.log = Logger.getLogger("com.github.fungal.Fungal");
        this.trace = this.log.isLoggable(Level.FINER);
    }

    private void deployUrls(URL[] urls) {
        if (urls != null && urls.length > 0) {
            TreeMap<Integer, ArrayList<URL>> sm = new TreeMap<Integer, ArrayList<URL>>();
            for (URL url : urls) {
                Integer index = this.kernelConfiguration.getDeploymentOrder().getOrderIndex(url);
                ArrayList<URL> l = (ArrayList<URL>)sm.get(index);
                if (l == null) {
                    l = new ArrayList<URL>(1);
                }
                l.add(url);
                sm.put(index, l);
            }
            for (List l : sm.values()) {
                try {
                    ArrayList<UnitDeployer> unitDeployers = new ArrayList<UnitDeployer>(l.size());
                    CountDownLatch unitLatch = new CountDownLatch(l.size());
                    for (URL url : l) {
                        try {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("URL=" + url.toString());
                            }
                            MainDeployerImpl deployer = (MainDeployerImpl)this.mainDeployer.clone();
                            UnitDeployer unitDeployer = new UnitDeployer(url, deployer, this.kernelClassLoader, unitLatch);
                            unitDeployers.add(unitDeployer);
                            this.getExecutorService().execute(unitDeployer);
                        }
                        catch (Throwable deployThrowable) {
                            this.log.log(Level.SEVERE, deployThrowable.getMessage(), deployThrowable);
                        }
                    }
                    unitLatch.await();
                    for (UnitDeployer deployer : unitDeployers) {
                        if (deployer.getThrowable() == null) continue;
                        Throwable t = deployer.getThrowable();
                        this.log.log(Level.SEVERE, t.getMessage(), t);
                    }
                }
                catch (Throwable t) {
                    this.log.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public void shutdown() throws Throwable {
        Throwable throwable = null;
        List<EventListener> els = this.kernelConfiguration.getEventListeners();
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.STOPPING);
            }
        }
        SecurityActions.setThreadContextClassLoader(this.kernelClassLoader);
        if (this.hotDeployer != null) {
            this.hotDeployer.stop();
        }
        if (this.remote != null) {
            this.setBeanStatus("Communicator", ServiceLifecycle.STOPPING);
            this.removeBean("Communicator", false);
            this.remote.stop();
        }
        if (this.jmxRemote != null) {
            this.jmxRemote.stop();
        }
        this.preUndeploy(false);
        if (this.deployments.size() > 0) {
            LinkedList<Deployment> shutdownDeployments = new LinkedList<Deployment>(this.deployments);
            Collections.reverse(shutdownDeployments);
            for (Deployment deployment : shutdownDeployments) {
                if (this.hotDeployer != null) {
                    this.hotDeployer.unregister(deployment.getURL());
                }
                try {
                    this.shutdownDeployment(deployment);
                }
                catch (Throwable t) {
                    if (throwable != null) continue;
                    throwable = t;
                }
            }
        }
        this.setBeanStatus("Kernel", ServiceLifecycle.STOPPING);
        this.removeBean("Kernel", false);
        if (this.beans.size() > 0) {
            LinkedList beanNames = new LinkedList(this.beans.keySet());
            for (String beanName : beanNames) {
                this.removeBean(beanName);
            }
        }
        if (this.mbeanServer != null) {
            ObjectName kernelObjectName;
            ObjectName hotDeployerObjectName;
            ObjectName mainDeployerObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=MainDeployer");
            if (this.mbeanServer.isRegistered(mainDeployerObjectName)) {
                this.mbeanServer.unregisterMBean(mainDeployerObjectName);
            }
            if (this.mbeanServer.isRegistered(hotDeployerObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=HotDeployer"))) {
                this.mbeanServer.unregisterMBean(hotDeployerObjectName);
            }
            if (this.mbeanServer.isRegistered(kernelObjectName = new ObjectName(this.kernelConfiguration.getName() + ":name=Kernel"))) {
                this.mbeanServer.unregisterMBean(kernelObjectName);
            }
            if (!this.kernelConfiguration.isUsePlatformMBeanServer()) {
                MBeanServerFactory.releaseMBeanServer(this.mbeanServer);
            }
        }
        if (this.getExecutorService() != null) {
            this.getExecutorService().shutdown();
        }
        if (this.temporaryEnvironment) {
            File tmp = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
            File root = new File(tmp, this.kernelConfiguration.getName());
            this.recursiveDelete(root);
        }
        SecurityActions.setSystemProperty(this.kernelConfiguration.getName() + ".home", "");
        SecurityActions.setSystemProperty(this.kernelConfiguration.getName() + ".bindaddress", "");
        if (els != null && els.size() > 0) {
            for (EventListener el : els) {
                el.event(this, Event.STOPPED);
            }
        }
        if (this.log != null) {
            this.log.info("Fungal 0.11.0.Final stopped");
        } else {
            System.out.println("Fungal 0.11.0.Final stopped");
        }
        if (this.kernelClassLoader != null) {
            try {
                this.kernelClassLoader.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SecurityActions.setThreadContextClassLoader(this.oldClassLoader);
        this.initialize();
        if (throwable != null) {
            throw throwable;
        }
    }

    void shutdownDeployment(Deployment deployment) throws Throwable {
        Throwable throwable;
        ClassLoader currentCL;
        block7: {
            currentCL = SecurityActions.getThreadContextClassLoader();
            SecurityActions.setThreadContextClassLoader(deployment.getClassLoader());
            throwable = null;
            try {
                Method stopMethod = SecurityActions.getMethod(deployment.getClass(), "stop", null);
                SecurityActions.setAccessible(stopMethod);
                stopMethod.invoke((Object)deployment, (Object[])null);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
                throwable = ite.getCause();
            }
            try {
                Method destroyMethod = SecurityActions.getMethod(deployment.getClass(), "destroy", null);
                SecurityActions.setAccessible(destroyMethod);
                destroyMethod.invoke((Object)deployment, (Object[])null);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
                if (throwable != null) break block7;
                throwable = ite.getCause();
            }
        }
        SecurityActions.setThreadContextClassLoader(currentCL);
        this.deployments.remove(deployment);
        if (throwable != null) {
            throw throwable;
        }
    }

    @Override
    public KernelClassLoader getKernelClassLoader() {
        if (this.kernelClassLoader == null) {
            throw new IllegalStateException("Kernel not started");
        }
        return this.kernelClassLoader;
    }

    private void setExecutorService(ThreadPoolExecutor v) {
        this.threadPoolExecutor = v;
    }

    public ExecutorService getExecutorService() {
        if (this.threadPoolExecutor == null) {
            throw new IllegalStateException("Thread pool is null");
        }
        return this.threadPoolExecutor;
    }

    KernelConfiguration getKernelConfiguration() {
        return this.kernelConfiguration;
    }

    ServiceLifecycle getBeanStatus(String name) {
        return (ServiceLifecycle)((Object)this.beanStatus.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBeanStatus(String name, ServiceLifecycle status) {
        this.beanStatus.put(name, status);
        if (this.trace) {
            this.log.log(Level.FINER, "Bean: " + name + ", Status: " + (Object)((Object)status));
        }
        if (status == ServiceLifecycle.NOT_STARTED) {
            List<CountDownLatch> l = this.beanLatches.get(name);
            if (l == null) {
                this.beanLatches.put(name, Collections.synchronizedList(new ArrayList(1)));
            }
        } else if (status == ServiceLifecycle.STARTED || status == ServiceLifecycle.ERROR) {
            Map<String, List<CountDownLatch>> map = this.beanLatches;
            synchronized (map) {
                List<CountDownLatch> l = this.beanLatches.get(name);
                if (l != null) {
                    for (CountDownLatch cdl : l) {
                        if (cdl.getCount() <= 0L) continue;
                        cdl.countDown();
                    }
                }
            }
        }
    }

    void addBean(String name, Object bean) {
        this.addBean(name, bean, true);
    }

    private void addBean(String name, Object bean, boolean mgt) {
        if (!this.beans.containsKey(name)) {
            this.beans.put(name, bean);
            if (mgt && this.kernelConfiguration.isManagement() && this.kernelConfiguration.isBeanManagement()) {
                try {
                    ObjectName on = new ObjectName(this.kernelConfiguration.getName() + ":name=" + name + ",type=Bean");
                    this.mbeanServer.registerMBean(JMX.createMBean(bean), on);
                }
                catch (Throwable t) {
                    this.log.log(Level.WARNING, "Error during management registering of bean [" + name + "]", t);
                }
            }
        } else {
            this.log.log(Level.SEVERE, "Bean [" + name + "] already exists (Existing=" + this.beans.get(name) + ", New=" + bean + ")");
        }
    }

    void removeBean(String name) {
        this.removeBean(name, true);
    }

    void removeBean(String name, boolean mgt) {
        Object bean;
        if (this.trace) {
            this.log.log(Level.FINER, "Removing bean: " + name);
        }
        if (this.uncallbacks.size() > 0 && (bean = this.beans.get(name)) != null && this.callbackBeans.containsKey(bean)) {
            for (Map.Entry entry : this.uncallbacks.entrySet()) {
                Class type = (Class)entry.getKey();
                List callbacks = (List)entry.getValue();
                if (!type.isInstance(bean)) continue;
                for (Callback cb : callbacks) {
                    try {
                        Method m = cb.getMethod();
                        Object instance = cb.getInstance();
                        SecurityActions.setAccessible(m);
                        m.invoke(instance, bean);
                    }
                    catch (Throwable t) {
                        if (!this.log.isLoggable(Level.FINE)) continue;
                        this.log.fine(cb.toString());
                    }
                }
            }
            this.callbackBeans.remove(bean);
        }
        this.deployerPhasesBeans.remove(name);
        this.beans.remove(name);
        this.beanStatus.remove(name);
        this.beanLatches.remove(name);
        if (mgt && this.kernelConfiguration.isManagement() && this.kernelConfiguration.isBeanManagement()) {
            try {
                ObjectName on = new ObjectName(this.kernelConfiguration.getName() + ":name=" + name + ",type=Bean");
                if (this.mbeanServer.isRegistered(on)) {
                    this.mbeanServer.unregisterMBean(on);
                }
            }
            catch (Throwable t) {
                this.log.log(Level.FINER, "Error during management unregistering of bean [" + name + "]", t);
            }
        }
    }

    @Override
    public <T> T getBean(String name, Class<T> expectedType) throws Throwable {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("ExpectedType is null");
        }
        if (!this.beans.containsKey(name)) {
            throw new IllegalArgumentException("Bean '" + name + "' doesn't exist");
        }
        return expectedType.cast(this.getBean(name));
    }

    @Override
    public BeanDeployment install(Bean ... beans) throws Throwable {
        DeployException deployException = null;
        try {
            if (beans != null) {
                for (Bean bt : beans) {
                    this.setBeanStatus(bt.getName(), ServiceLifecycle.NOT_STARTED);
                }
                this.beansRegistered();
                ArrayList<BeanDeployer> deployers = new ArrayList<BeanDeployer>(beans.length);
                List<String> beanNames = Collections.synchronizedList(new ArrayList(beans.length));
                ConcurrentHashMap<String, List<Method>> uninstall = new ConcurrentHashMap<String, List<Method>>(beans.length);
                Map<String, String> stops = Collections.synchronizedMap(new HashMap(beans.length));
                Map<String, String> destroys = Collections.synchronizedMap(new HashMap(beans.length));
                Set<String> ignoreStops = Collections.synchronizedSet(new HashSet(beans.length));
                Set<String> ignoreDestroys = Collections.synchronizedSet(new HashSet(beans.length));
                CountDownLatch beansLatch = new CountDownLatch(beans.length);
                for (Bean bt : beans) {
                    BeanDeployer deployer = new BeanDeployer(bt, beanNames, uninstall, stops, destroys, ignoreStops, ignoreDestroys, this, beansLatch, this.kernelClassLoader, this.log);
                    deployers.add(deployer);
                    this.getExecutorService().submit(deployer);
                }
                beansLatch.await();
                Iterator it = deployers.iterator();
                while (deployException == null && it.hasNext()) {
                    BeanDeployer deployer = (BeanDeployer)it.next();
                    if (deployer.getDeployException() == null) continue;
                    deployException = deployer.getDeployException();
                }
                if (deployException == null) {
                    BeanDeploymentImpl deployment = new BeanDeploymentImpl(null, beanNames, uninstall, stops, destroys, ignoreStops, ignoreDestroys, this);
                    this.registerDeployment(deployment);
                    return deployment;
                }
            }
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, t.getMessage(), t);
            throw new DeployException("Unable to deploy: " + beans, t);
        }
        if (deployException != null) {
            throw new DeployException("Unable to deploy: " + beans, deployException);
        }
        return null;
    }

    @Override
    public void uninstall(BeanDeployment beans) throws Throwable {
        if (beans != null) {
            this.preUndeploy(true);
            this.shutdownDeployment(beans);
            this.postUndeploy(true);
        }
    }

    public Object getBean(String name) {
        return this.beans.get(name);
    }

    Set<String> getBeanDependants(String name) {
        return (Set)this.beanDependants.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBeanDependants(String from, String to, CountDownLatch cdl) {
        HashSet<String> newDependants;
        HashSet<String> dependants = (HashSet<String>)this.beanDependants.get(from);
        if (dependants == null && (dependants = (Set)this.beanDependants.putIfAbsent(from, newDependants = new HashSet<String>(1))) == null) {
            dependants = newDependants;
        }
        dependants.add(to);
        ServiceLifecycle slc = this.getBeanStatus(to);
        boolean doCountDown = true;
        if (slc != ServiceLifecycle.STARTED && slc != ServiceLifecycle.ERROR) {
            Map<String, List<CountDownLatch>> map = this.beanLatches;
            synchronized (map) {
                slc = this.getBeanStatus(to);
                if (slc != ServiceLifecycle.STARTED && slc != ServiceLifecycle.ERROR) {
                    List<CountDownLatch> l = this.beanLatches.get(to);
                    if (l == null) {
                        l = Collections.synchronizedList(new ArrayList(1));
                        this.beanLatches.put(to, l);
                    }
                    l.add(cdl);
                    doCountDown = false;
                }
            }
        }
        if (doCountDown) {
            cdl.countDown();
        }
    }

    void registerDeployment(Deployment deployment) {
        this.deployments.add(deployment);
        if (this.started && deployment instanceof BeanDeployment) {
            this.incallback();
        }
    }

    void beansRegistered() {
        this.beanDeployments.decrementAndGet();
    }

    boolean isAllBeansRegistered() {
        return this.beanDeployments.get() <= 0;
    }

    @Override
    public MainDeployer getMainDeployer() {
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Kernel not started");
        }
        try {
            return (MainDeployer)this.mainDeployer.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return this.mainDeployer;
        }
    }

    public HotDeployer getHotDeployer() {
        return this.hotDeployer;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        Iterator it = new TreeSet(this.beans.keySet()).iterator();
        while (it.hasNext()) {
            this.dumpBean(sb, (String)it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String dump(String name) {
        StringBuilder sb = new StringBuilder();
        this.dumpBean(sb, name);
        return sb.toString();
    }

    private void dumpBean(StringBuilder sb, String name) {
        if (this.beans.containsKey(name)) {
            sb.append("Bean \"").append(name).append("\" (").append(this.beanStatus.get(name)).append(")\n");
            sb.append("  Class: ").append(this.beans.get(name).getClass().getName()).append("\n");
            if (this.beanDependants.containsKey(name)) {
                sb.append("  DependsOn: ");
                Iterator it = ((Set)this.beanDependants.get(name)).iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            } else {
                sb.append("  DependsOn: None");
            }
            sb.append("\n");
        } else {
            sb.append("Bean \"").append(name).append("\" not found");
        }
    }

    void registerIncallback(Callback cb) {
        List<Callback> callbacks = (List<Callback>)this.incallbacks.get(cb.getType());
        if (callbacks == null) {
            List newCallbacks = Collections.synchronizedList(new ArrayList(1));
            callbacks = this.incallbacks.putIfAbsent(cb.getType(), newCallbacks);
            if (callbacks == null) {
                callbacks = newCallbacks;
            }
        }
        callbacks.add(cb);
    }

    void registerUncallback(Callback cb) {
        List<Callback> callbacks = (List<Callback>)this.uncallbacks.get(cb.getType());
        if (callbacks == null) {
            List newCallbacks = Collections.synchronizedList(new ArrayList(1));
            callbacks = this.uncallbacks.putIfAbsent(cb.getType(), newCallbacks);
            if (callbacks == null) {
                callbacks = newCallbacks;
            }
        }
        callbacks.add(cb);
    }

    private void incallback() {
        if (this.incallbacks.size() > 0) {
            for (Map.Entry entry : this.incallbacks.entrySet()) {
                Class type = (Class)entry.getKey();
                List callbacks = (List)entry.getValue();
                for (Object bean : this.beans.values()) {
                    if (!type.isInstance(bean)) continue;
                    for (Callback cb : callbacks) {
                        ArrayList<Callback> registeredCallbacks = (ArrayList<Callback>)this.callbackBeans.get(bean);
                        if (registeredCallbacks != null && registeredCallbacks.contains(cb)) continue;
                        if (registeredCallbacks == null) {
                            registeredCallbacks = new ArrayList<Callback>(1);
                        }
                        try {
                            Method m = cb.getMethod();
                            Object instance = cb.getInstance();
                            SecurityActions.setAccessible(m);
                            m.invoke(instance, bean);
                            registeredCallbacks.add(cb);
                            this.callbackBeans.put(bean, registeredCallbacks);
                        }
                        catch (Throwable t) {
                            if (!this.log.isLoggable(Level.FINE)) continue;
                            this.log.fine(cb.toString());
                        }
                    }
                }
            }
        }
    }

    private URL[] getUrls(File directory) throws MalformedURLException, IOException {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            List<URL> result = this.scanUrls(directory);
            return result.toArray(new URL[result.size()]);
        }
        return new URL[0];
    }

    private List<URL> scanUrls(File f) throws MalformedURLException, IOException {
        LinkedList<URL> result = new LinkedList<URL>();
        if (f != null && f.exists()) {
            if (f.isDirectory()) {
                result.add(f.toURI().toURL());
                File[] jars = f.listFiles();
                if (jars != null) {
                    for (int j = 0; j < jars.length; ++j) {
                        List<URL> deeper = this.scanUrls(jars[j]);
                        result.addAll(deeper);
                    }
                }
            } else if (f.getName().endsWith(".jar")) {
                result.add(f.getCanonicalFile().toURI().toURL());
            }
        }
        return result;
    }

    private URL[] mergeUrls(URL[] ... urls) {
        if (urls != null) {
            LinkedList<URL> list = new LinkedList<URL>();
            for (URL[] u : urls) {
                if (u == null) continue;
                for (URL url : u) {
                    list.add(url);
                }
            }
            return list.toArray(new URL[list.size()]);
        }
        return new URL[0];
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    void addDeployerPhasesBean(String bean) {
        this.newDeployerPhasesBeans.add(bean);
    }

    void preDeploy(boolean delegate) throws Throwable {
        if (this.newDeployerPhasesBeans.size() > 0) {
            this.deployerPhasesBeans.addAll(this.newDeployerPhasesBeans);
            this.newDeployerPhasesBeans.clear();
        }
        for (String beanName : this.deployerPhasesBeans) {
            DeployerPhases bean = (DeployerPhases)this.getBean(beanName);
            if (bean == null || this.getBeanStatus(beanName) != ServiceLifecycle.STARTED) continue;
            if (delegate) {
                bean.preDeploy();
                continue;
            }
            try {
                bean.preDeploy();
            }
            catch (Throwable t) {
                this.log.log(Level.WARNING, t.getMessage(), t);
            }
        }
    }

    void postDeploy(boolean delegate) throws Throwable {
        this.beanLatches.clear();
        if (this.newDeployerPhasesBeans.size() > 0) {
            this.deployerPhasesBeans.addAll(this.newDeployerPhasesBeans);
            this.newDeployerPhasesBeans.clear();
        }
        for (String beanName : this.deployerPhasesBeans) {
            DeployerPhases bean = (DeployerPhases)this.getBean(beanName);
            if (bean == null || this.getBeanStatus(beanName) != ServiceLifecycle.STARTED) continue;
            if (delegate) {
                bean.postDeploy();
                continue;
            }
            try {
                bean.postDeploy();
            }
            catch (Throwable t) {
                this.log.log(Level.WARNING, t.getMessage(), t);
            }
        }
    }

    void preUndeploy(boolean delegate) throws Throwable {
        for (String beanName : this.deployerPhasesBeans) {
            DeployerPhases bean = (DeployerPhases)this.getBean(beanName);
            if (bean == null || this.getBeanStatus(beanName) != ServiceLifecycle.STARTED) continue;
            if (delegate) {
                bean.preUndeploy();
                continue;
            }
            try {
                bean.preUndeploy();
            }
            catch (Throwable t) {
                this.log.log(Level.WARNING, t.getMessage(), t);
            }
        }
    }

    void postUndeploy(boolean delegate) throws Throwable {
        for (String beanName : this.deployerPhasesBeans) {
            DeployerPhases bean = (DeployerPhases)this.getBean(beanName);
            if (bean == null || this.getBeanStatus(beanName) != ServiceLifecycle.STARTED) continue;
            if (delegate) {
                bean.postUndeploy();
                continue;
            }
            try {
                bean.postUndeploy();
            }
            catch (Throwable t) {
                this.log.log(Level.WARNING, t.getMessage(), t);
            }
        }
    }

    static class UnitDeployer
    implements Runnable {
        private URL url;
        private MainDeployerImpl deployer;
        private ClassLoader classLoader;
        private CountDownLatch unitLatch;
        private Throwable throwable;

        public UnitDeployer(URL url, MainDeployerImpl deployer, ClassLoader classLoader, CountDownLatch unitLatch) {
            this.url = url;
            this.deployer = deployer;
            this.classLoader = classLoader;
            this.unitLatch = unitLatch;
            this.throwable = null;
        }

        @Override
        public void run() {
            SecurityActions.setThreadContextClassLoader(this.classLoader);
            try {
                this.deployer.deploy(this.url, false, this.classLoader);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            this.unitLatch.countDown();
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

