/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.impl.classloader.ArchiveClassLoader;
import com.github.fungal.impl.classloader.NonExportClassLoader;
import com.github.fungal.impl.classloader.SecurityActions;
import com.github.fungal.impl.classloader.VersionComparator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

class ExportClassLoaderRepository {
    private NonExportClassLoader nonExportClassLoader = SecurityActions.createNonExportClassLoader(this);
    private AtomicInteger idCounter = new AtomicInteger(0);
    private ConcurrentMap<Integer, ArchiveClassLoader> classLoaders = new ConcurrentHashMap<Integer, ArchiveClassLoader>();
    private ConcurrentMap<String, SortedMap<String, Set<Integer>>> packages = new ConcurrentHashMap<String, SortedMap<String, Set<Integer>>>();

    ExportClassLoaderRepository() {
    }

    NonExportClassLoader getNonExportClassLoader() {
        return this.nonExportClassLoader;
    }

    ArchiveClassLoader getClassLoader(Integer id) {
        return (ArchiveClassLoader)this.classLoaders.get(id);
    }

    Set<Integer> getClassLoaders(String clz) {
        String pkgName = this.getPackageName(clz);
        SortedMap sm = (SortedMap)this.packages.get(pkgName);
        if (sm != null) {
            String lastKey = (String)sm.lastKey();
            return (Set)sm.get(lastKey);
        }
        return null;
    }

    Set<Integer> getClassLoaders() {
        HashSet<Integer> result = new HashSet<Integer>();
        Collection sms = this.packages.values();
        for (SortedMap sm : sms) {
            String lastKey;
            Set values = (Set)sm.get(lastKey = (String)sm.lastKey());
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Set<Integer> register(URL[] urls) {
        if (urls == null) {
            return null;
        }
        HashSet<Integer> result = null;
        HashMap imports = new HashMap();
        for (URL url : urls) {
            boolean added = false;
            if ("file".equals(url.getProtocol())) {
                ZipFile jarFile = null;
                try {
                    Attributes mainAttributes;
                    String bundleManifestVersion;
                    Manifest manifest;
                    File f = new File(url.toURI());
                    if (f.isFile() && (manifest = ((JarFile)(jarFile = new JarFile(f))).getManifest()) != null && (bundleManifestVersion = (mainAttributes = manifest.getMainAttributes()).getValue("Bundle-ManifestVersion")) != null) {
                        Integer identifier = this.idCounter.getAndIncrement();
                        String bundleVersion = mainAttributes.getValue("Bundle-Version");
                        String input = mainAttributes.getValue("Export-Package");
                        boolean semi = false;
                        boolean quote = false;
                        StringBuilder sb = new StringBuilder();
                        HashSet<String> exportPackages = new HashSet<String>(1);
                        for (int i = 0; i < input.length(); ++i) {
                            char c = input.charAt(i);
                            if (c == ',') {
                                if (quote) continue;
                                String exportPackage = sb.toString().trim();
                                semi = false;
                                quote = false;
                                sb = new StringBuilder();
                                if (exportPackage.equals("")) continue;
                                exportPackages.add(exportPackage);
                                continue;
                            }
                            if (c == ';') {
                                semi = true;
                                continue;
                            }
                            if (c == '\"') {
                                quote = !quote;
                                continue;
                            }
                            if (semi) continue;
                            sb = sb.append(c);
                        }
                        if (sb.length() > 0) {
                            exportPackages.add(sb.toString().trim());
                        }
                        if ((input = mainAttributes.getValue("Import-Package")) != null) {
                            StringTokenizer st = new StringTokenizer(input, ",");
                            while (st.hasMoreTokens()) {
                                ArrayList<String> l;
                                HashMap<String, ArrayList<String>> value;
                                String token = st.nextToken().trim();
                                int versionIndex = token.indexOf(";version=");
                                if (versionIndex == -1) continue;
                                String pkg = token.substring(0, versionIndex);
                                String ver = token.substring(versionIndex + 9);
                                if (pkg.indexOf(";") != -1) {
                                    pkg = pkg.substring(0, pkg.indexOf(";"));
                                }
                                if (ver.startsWith("\"")) {
                                    ver = ver.substring(1);
                                }
                                if (ver.endsWith("\"")) {
                                    ver = ver.substring(0, ver.length() - 1);
                                }
                                if ((value = (HashMap<String, ArrayList<String>>)imports.get(identifier)) == null) {
                                    value = new HashMap<String, ArrayList<String>>();
                                }
                                if ((l = (ArrayList<String>)value.get(ver)) == null) {
                                    l = new ArrayList<String>();
                                }
                                l.add(pkg);
                                value.put(ver, l);
                                imports.put(identifier, value);
                            }
                        }
                        if ((input = mainAttributes.getValue("Require-Bundle")) != null) {
                            StringTokenizer st = new StringTokenizer(input, ",");
                            while (st.hasMoreTokens()) {
                                ArrayList<String> l;
                                HashMap<Object, ArrayList<String>> value;
                                String token = st.nextToken().trim();
                                int delimiter = token.indexOf(";");
                                if (delimiter != -1) {
                                    token = token.substring(0, delimiter);
                                }
                                if ((value = (HashMap<Object, ArrayList<String>>)imports.get(identifier)) == null) {
                                    value = new HashMap<Object, ArrayList<String>>();
                                }
                                if ((l = (ArrayList<String>)value.get(null)) == null) {
                                    l = new ArrayList<String>();
                                }
                                l.add(token);
                                value.put(null, l);
                                imports.put(identifier, value);
                            }
                        }
                        for (String s : exportPackages) {
                            HashSet<Integer> cls;
                            TreeMap<String, HashSet<Integer>> sm = (TreeMap<String, HashSet<Integer>>)this.packages.get(s);
                            if (sm == null) {
                                sm = new TreeMap<String, HashSet<Integer>>(new VersionComparator());
                            }
                            if ((cls = (HashSet<Integer>)sm.get(bundleVersion)) == null) {
                                cls = new HashSet<Integer>(1);
                            }
                            cls.add(identifier);
                            sm.put(bundleVersion, cls);
                            this.packages.put(s, sm);
                        }
                        ArchiveClassLoader acl = SecurityActions.createArchiveClassLoader(identifier, url, exportPackages, this);
                        this.classLoaders.put(acl.getId(), acl);
                        if (result == null) {
                            result = new HashSet<Integer>();
                        }
                        result.add(identifier);
                        added = true;
                    }
                }
                catch (Throwable t) {
                    System.out.println("REPO: (" + url + ") =");
                    t.printStackTrace(System.out);
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            if (added) continue;
            this.nonExportClassLoader.addURL(url);
        }
        if (imports.size() > 0) {
            for (Map.Entry cEntry : imports.entrySet()) {
                Integer classLoaderId = (Integer)cEntry.getKey();
                Map value = (Map)cEntry.getValue();
                ArchiveClassLoader acl = this.getClassLoader(classLoaderId);
                for (Map.Entry vEntry : value.entrySet()) {
                    String version = (String)vEntry.getKey();
                    List pkgs = (List)vEntry.getValue();
                    for (String pkg : pkgs) {
                        SortedMap sm = (SortedMap)this.packages.get(pkg);
                        if (sm == null) continue;
                        Set clIds = (Set)sm.get(version);
                        if (clIds == null) {
                            clIds = (Set)sm.get(sm.lastKey());
                        }
                        for (Integer cid : clIds) {
                            acl.addImportClassLoader(cid);
                            result.add(cid);
                        }
                    }
                }
            }
        }
        return result;
    }

    private String getPackageName(String name) {
        String packageName = "";
        int lastDot = name.lastIndexOf(".");
        if (lastDot != -1) {
            packageName = name.substring(0, lastDot);
        }
        return packageName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportClassLoaderRepository@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[NonExportClassLoader=").append(Integer.toHexString(System.identityHashCode(this.nonExportClassLoader)));
        sb.append(", IdCounter=").append(this.idCounter);
        sb.append(", ClassLoaders=").append(this.classLoaders);
        sb.append(", Packages=").append(this.packages);
        sb.append("]");
        return sb.toString();
    }
}

