package org.jboss.jca.embedded.dsl.ironjacamar13.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar13.api.WorkmanagerType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.ironjacamar13.api.WorkmanagerSecurityType;
import org.jboss.jca.embedded.dsl.ironjacamar13.impl.WorkmanagerSecurityTypeImpl;

/**
 * This class implements the <code> workmanagerType </code> xsd type 
 */
public class WorkmanagerTypeImpl<T> implements Child<T>, WorkmanagerType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerType ElementName: ironjacamar:workmanagerSecurityType ElementType : security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security</code> element with the given value will be created.
    * Otherwise, the existing <code>security</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityType<WorkmanagerType<T>></code> 
    */
   public WorkmanagerSecurityType<WorkmanagerType<T>> getOrCreateSecurity()
   {
      Node node = childNode.getOrCreate("security");
      WorkmanagerSecurityType<WorkmanagerType<T>> security = new WorkmanagerSecurityTypeImpl<WorkmanagerType<T>>(this, "security", childNode, node);
      return security;
   }

   /**
    * Removes the <code>security</code> element 
    * @return the current instance of <code>WorkmanagerType<T></code> 
    */
   public WorkmanagerType<T> removeSecurity()
   {
      childNode.removeChildren("security");
      return this;
   }
}
