package org.ironjacamar.embedded.dsl.ironjacamar20.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.ironjacamar.embedded.dsl.ironjacamar20.api.PoolType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.ironjacamar.embedded.dsl.ironjacamar20.api.CapacityType;
import org.ironjacamar.embedded.dsl.ironjacamar20.impl.CapacityTypeImpl;

/**
 * This class implements the <code> poolType </code> xsd type 
 */
public class PoolTypeImpl<T> implements Child<T>, PoolType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PoolTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PoolTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:nonNegativeInteger ElementType : min-pool-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>min-pool-size</code> element
    * @param minPoolSize the value for the element <code>min-pool-size</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> minPoolSize(Integer minPoolSize)
   {
      childNode.getOrCreate("min-pool-size").text(minPoolSize);
      return this;
   }

   /**
    * Returns the <code>min-pool-size</code> element
    * @return the node defined for the element <code>min-pool-size</code> 
    */
   public Integer getMinPoolSize()
   {
      if (childNode.getTextValueForPatternName("min-pool-size") != null && !childNode.getTextValueForPatternName("min-pool-size").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("min-pool-size"));
      }
      return null;
   }

   /**
    * Removes the <code>min-pool-size</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeMinPoolSize()
   {
      childNode.removeChildren("min-pool-size");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:nonNegativeInteger ElementType : initial-pool-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>initial-pool-size</code> element
    * @param initialPoolSize the value for the element <code>initial-pool-size</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> initialPoolSize(Integer initialPoolSize)
   {
      childNode.getOrCreate("initial-pool-size").text(initialPoolSize);
      return this;
   }

   /**
    * Returns the <code>initial-pool-size</code> element
    * @return the node defined for the element <code>initial-pool-size</code> 
    */
   public Integer getInitialPoolSize()
   {
      if (childNode.getTextValueForPatternName("initial-pool-size") != null && !childNode.getTextValueForPatternName("initial-pool-size").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("initial-pool-size"));
      }
      return null;
   }

   /**
    * Removes the <code>initial-pool-size</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeInitialPoolSize()
   {
      childNode.removeChildren("initial-pool-size");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:nonNegativeInteger ElementType : max-pool-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>max-pool-size</code> element
    * @param maxPoolSize the value for the element <code>max-pool-size</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> maxPoolSize(Integer maxPoolSize)
   {
      childNode.getOrCreate("max-pool-size").text(maxPoolSize);
      return this;
   }

   /**
    * Returns the <code>max-pool-size</code> element
    * @return the node defined for the element <code>max-pool-size</code> 
    */
   public Integer getMaxPoolSize()
   {
      if (childNode.getTextValueForPatternName("max-pool-size") != null && !childNode.getTextValueForPatternName("max-pool-size").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("max-pool-size"));
      }
      return null;
   }

   /**
    * Removes the <code>max-pool-size</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeMaxPoolSize()
   {
      childNode.removeChildren("max-pool-size");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:boolean ElementType : prefill
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>prefill</code> element
    * @param prefill the value for the element <code>prefill</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> prefill(Boolean prefill)
   {
      childNode.getOrCreate("prefill").text(prefill);
      return this;
   }

   /**
    * Returns the <code>prefill</code> element
    * @return the node defined for the element <code>prefill</code> 
    */
   public Boolean isPrefill()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("prefill"));
   }

   /**
    * Removes the <code>prefill</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removePrefill()
   {
      childNode.removeChildren("prefill");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:token ElementType : flush-strategy
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>flush-strategy</code> element
    * @param flushStrategy the value for the element <code>flush-strategy</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> flushStrategy(String flushStrategy)
   {
      childNode.getOrCreate("flush-strategy").text(flushStrategy);
      return this;
   }

   /**
    * Returns the <code>flush-strategy</code> element
    * @return the node defined for the element <code>flush-strategy</code> 
    */
   public String getFlushStrategy()
   {
      return childNode.getTextValueForPatternName("flush-strategy");
   }

   /**
    * Removes the <code>flush-strategy</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeFlushStrategy()
   {
      childNode.removeChildren("flush-strategy");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: ironjacamar:capacityType ElementType : capacity
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>capacity</code> element with the given value will be created.
    * Otherwise, the existing <code>capacity</code> element will be returned.
    * @return  a new or existing instance of <code>CapacityType<PoolType<T>></code> 
    */
   public CapacityType<PoolType<T>> getOrCreateCapacity()
   {
      Node node = childNode.getOrCreate("capacity");
      CapacityType<PoolType<T>> capacity = new CapacityTypeImpl<PoolType<T>>(this, "capacity", childNode, node);
      return capacity;
   }

   /**
    * Removes the <code>capacity</code> element 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeCapacity()
   {
      childNode.removeChildren("capacity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:token ElementType : type
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>type</code> attribute
    * @param type the value for the attribute <code>type</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> type(String type)
   {
      childNode.attribute("type", type);
      return this;
   }

   /**
    * Returns the <code>type</code> attribute
    * @return the value defined for the attribute <code>type</code> 
    */
      public String getType()
   {
      return childNode.getAttribute("type");
   }

   /**
    * Removes the <code>type</code> attribute 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeType()
   {
      childNode.removeAttribute("type");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolType ElementName: xsd:token ElementType : janitor
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>janitor</code> attribute
    * @param janitor the value for the attribute <code>janitor</code> 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> janitor(String janitor)
   {
      childNode.attribute("janitor", janitor);
      return this;
   }

   /**
    * Returns the <code>janitor</code> attribute
    * @return the value defined for the attribute <code>janitor</code> 
    */
      public String getJanitor()
   {
      return childNode.getAttribute("janitor");
   }

   /**
    * Removes the <code>janitor</code> attribute 
    * @return the current instance of <code>PoolType<T></code> 
    */
   public PoolType<T> removeJanitor()
   {
      childNode.removeAttribute("janitor");
      return this;
   }
}
