package org.ironjacamar.embedded.dsl.resourceadapters20.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.ironjacamar.embedded.dsl.resourceadapters20.api.RecoverType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.ironjacamar.embedded.dsl.resourceadapters20.api.CredentialType;
import org.ironjacamar.embedded.dsl.resourceadapters20.impl.CredentialTypeImpl;
import org.ironjacamar.embedded.dsl.resourceadapters20.api.ExtensionType;
import org.ironjacamar.embedded.dsl.resourceadapters20.impl.ExtensionTypeImpl;

/**
 * This class implements the <code> recoverType </code> xsd type 
 */
public class RecoverTypeImpl<T> implements Child<T>, RecoverType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public RecoverTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public RecoverTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RecoverType ElementName: resource-adapters:credentialType ElementType : recovery-credential
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>recovery-credential</code> element with the given value will be created.
    * Otherwise, the existing <code>recovery-credential</code> element will be returned.
    * @return  a new or existing instance of <code>CredentialType<RecoverType<T>></code> 
    */
   public CredentialType<RecoverType<T>> getOrCreateRecoveryCredential()
   {
      Node node = childNode.getOrCreate("recovery-credential");
      CredentialType<RecoverType<T>> recoveryCredential = new CredentialTypeImpl<RecoverType<T>>(this, "recovery-credential", childNode, node);
      return recoveryCredential;
   }

   /**
    * Removes the <code>recovery-credential</code> element 
    * @return the current instance of <code>RecoverType<T></code> 
    */
   public RecoverType<T> removeRecoveryCredential()
   {
      childNode.removeChildren("recovery-credential");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RecoverType ElementName: resource-adapters:extensionType ElementType : recovery-plugin
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>recovery-plugin</code> element with the given value will be created.
    * Otherwise, the existing <code>recovery-plugin</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<RecoverType<T>></code> 
    */
   public ExtensionType<RecoverType<T>> getOrCreateRecoveryPlugin()
   {
      Node node = childNode.getOrCreate("recovery-plugin");
      ExtensionType<RecoverType<T>> recoveryPlugin = new ExtensionTypeImpl<RecoverType<T>>(this, "recovery-plugin", childNode, node);
      return recoveryPlugin;
   }

   /**
    * Removes the <code>recovery-plugin</code> element 
    * @return the current instance of <code>RecoverType<T></code> 
    */
   public RecoverType<T> removeRecoveryPlugin()
   {
      childNode.removeChildren("recovery-plugin");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RecoverType ElementName: xsd:boolean ElementType : no-recovery
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>no-recovery</code> attribute
    * @param noRecovery the value for the attribute <code>no-recovery</code> 
    * @return the current instance of <code>RecoverType<T></code> 
    */
   public RecoverType<T> noRecovery(Boolean noRecovery)
   {
      childNode.attribute("no-recovery", noRecovery);
      return this;
   }

   /**
    * Returns the <code>no-recovery</code> attribute
    * @return the value defined for the attribute <code>no-recovery</code> 
    */
   public Boolean isNoRecovery()
   {
      return Strings.isTrue(childNode.getAttribute("no-recovery"));
   }

   /**
    * Removes the <code>no-recovery</code> attribute 
    * @return the current instance of <code>RecoverType<T></code> 
    */
   public RecoverType<T> removeNoRecovery()
   {
      childNode.removeAttribute("no-recovery");
      return this;
   }
}
