package org.ironjacamar.embedded.dsl.resourceadapters20.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.ironjacamar.embedded.dsl.resourceadapters20.api.WorkmanagerSecurityMappingType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> workmanagerSecurityMappingType </code> xsd type 
 */
public class WorkmanagerSecurityMappingTypeImpl<T> implements Child<T>, WorkmanagerSecurityMappingType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityMappingTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityMappingTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingType ElementName: xsd:token ElementType : from
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>from</code> attribute
    * @param from the value for the attribute <code>from</code> 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<T></code> 
    */
   public WorkmanagerSecurityMappingType<T> from(String from)
   {
      childNode.attribute("from", from);
      return this;
   }

   /**
    * Returns the <code>from</code> attribute
    * @return the value defined for the attribute <code>from</code> 
    */
      public String getFrom()
   {
      return childNode.getAttribute("from");
   }

   /**
    * Removes the <code>from</code> attribute 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<T></code> 
    */
   public WorkmanagerSecurityMappingType<T> removeFrom()
   {
      childNode.removeAttribute("from");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingType ElementName: xsd:token ElementType : to
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>to</code> attribute
    * @param to the value for the attribute <code>to</code> 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<T></code> 
    */
   public WorkmanagerSecurityMappingType<T> to(String to)
   {
      childNode.attribute("to", to);
      return this;
   }

   /**
    * Returns the <code>to</code> attribute
    * @return the value defined for the attribute <code>to</code> 
    */
      public String getTo()
   {
      return childNode.getAttribute("to");
   }

   /**
    * Removes the <code>to</code> attribute 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<T></code> 
    */
   public WorkmanagerSecurityMappingType<T> removeTo()
   {
      childNode.removeAttribute("to");
      return this;
   }
}
