/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.byteman.modules.ModuleSystem;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class HelperManager {
    private Instrumentation inst;
    private ModuleSystem moduleSystem;
    private ConcurrentHashMap<Class<?>, LifecycleDetails> helperDetailsMap;
    private static final String ACTIVATED_NAME = "activated";
    private static final String DEACTIVATED_NAME = "deactivated";
    private static final String INSTALLED_NAME = "installed";
    private static final String UNINSTALLED_NAME = "uninstalled";
    private static final Class[] ACTIVATED_SIGNATURE = null;
    private static final Class[] DEACTIVATED_SIGNATURE = null;
    private static final Class[] INSTALLED_RULE_SIGNATURE = new Class[]{Rule.class};
    private static final Class[] UNINSTALLED_RULE_SIGNATURE = INSTALLED_RULE_SIGNATURE;
    private static final Class[] INSTALLED_STRING_SIGNATURE = new Class[]{String.class};
    private static final Class[] UNINSTALLED_STRING_SIGNATURE = INSTALLED_STRING_SIGNATURE;

    public HelperManager(Instrumentation inst, ModuleSystem moduleSystem) {
        this.inst = inst;
        this.moduleSystem = moduleSystem;
        this.helperDetailsMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installed(Rule rule) {
        Class helperClass = rule.getHelperClass();
        Helper.verbose("HelperManager.install for helper class " + helperClass.getName());
        Class clazz = helperClass;
        synchronized (clazz) {
            LifecycleDetails details = this.getDetails(helperClass, true);
            if (details.installCount == 0 && details.activated != null) {
                Helper.verbose("calling activated() for helper class " + helperClass.getName());
                try {
                    details.activated.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    Helper.err("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".activate() : " + e);
                    Helper.errTraceException(e);
                }
            }
            if (details.installed != null) {
                Helper.verbose("calling installed(" + rule.getName() + ") for helper class" + helperClass.getName());
                try {
                    if (details.installedTakesRule) {
                        details.installed.invoke(null, rule);
                    } else {
                        details.installed.invoke(null, rule.getName());
                    }
                }
                catch (Exception e) {
                    Helper.err("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".installed(String) : " + e);
                    Helper.errTraceException(e);
                }
            }
            ++details.installCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstalled(Rule rule) {
        Class helperClass = rule.getHelperClass();
        Helper.verbose("HelperManager.uninstall for helper class " + helperClass.getName());
        Class clazz = helperClass;
        synchronized (clazz) {
            LifecycleDetails details = this.getDetails(helperClass, false);
            if (details == null) {
                Helper.err("HelperManager.uninstalled : shouldn't happen! uninstall failed to locate helper details for " + helperClass.getName());
                return;
            }
            --details.installCount;
            if (details.uninstalled != null) {
                Helper.verbose("calling uninstalled(" + rule.getName() + ") for helper class " + helperClass.getName());
                try {
                    if (details.uninstalledTakesRule) {
                        details.uninstalled.invoke(null, rule);
                    } else {
                        details.uninstalled.invoke(null, rule.getName());
                    }
                }
                catch (Exception e) {
                    Helper.err("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".uninstalled(String) : " + e);
                    Helper.errTraceException(e);
                }
            }
            if (details.installCount == 0 && details.deactivated != null) {
                Helper.verbose("calling deactivated() for helper class" + helperClass.getName());
                try {
                    details.deactivated.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    Helper.err("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".deactivate() : " + e);
                    Helper.errTraceException(e);
                }
            }
            if (details.installCount == 0) {
                this.purgeDetails(details);
            }
        }
    }

    public long getObjectSize(Object o) {
        if (this.inst == null) {
            Helper.err("Cannot calculate object size since a Byteman agent has not been installed");
            return -1L;
        }
        return this.inst.getObjectSize(o);
    }

    public ModuleSystem getModuleSystem() {
        return this.moduleSystem;
    }

    private LifecycleDetails getDetails(Class<?> helperClass, boolean createIfAbsent) {
        LifecycleDetails details = this.helperDetailsMap.get(helperClass);
        if (details == null && createIfAbsent) {
            details = new LifecycleDetails(helperClass);
            details.activated = this.lookupLifecycleMethod(helperClass, ACTIVATED_NAME, ACTIVATED_SIGNATURE);
            details.deactivated = this.lookupLifecycleMethod(helperClass, DEACTIVATED_NAME, DEACTIVATED_SIGNATURE);
            details.installed = this.lookupLifecycleMethod(helperClass, INSTALLED_NAME, INSTALLED_RULE_SIGNATURE);
            details.uninstalled = this.lookupLifecycleMethod(helperClass, UNINSTALLED_NAME, UNINSTALLED_RULE_SIGNATURE);
            if (details.installed != null) {
                details.installedTakesRule = true;
            } else {
                details.installed = this.lookupLifecycleMethod(helperClass, INSTALLED_NAME, INSTALLED_STRING_SIGNATURE);
            }
            if (details.uninstalled != null) {
                details.uninstalledTakesRule = true;
            } else {
                details.uninstalled = this.lookupLifecycleMethod(helperClass, UNINSTALLED_NAME, UNINSTALLED_STRING_SIGNATURE);
            }
            this.helperDetailsMap.put(helperClass, details);
        }
        return details;
    }

    private Method lookupLifecycleMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            Method m = clazz.getMethod(name, paramTypes);
            int mod = m.getModifiers();
            if (Modifier.isStatic(mod)) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private void purgeDetails(LifecycleDetails details) {
        this.helperDetailsMap.remove(details.lifecycleClass);
    }

    private static class LifecycleDetails {
        public Class<?> lifecycleClass;
        public int installCount;
        public Method activated;
        public Method deactivated;
        public Method installed;
        public boolean installedTakesRule;
        public Method uninstalled;
        public boolean uninstalledTakesRule;

        public LifecycleDetails(Class<?> lifecycleClass) {
            this.lifecycleClass = lifecycleClass;
            this.installCount = 0;
        }
    }
}

