/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class TypeGroup {
    protected HashMap<String, Type> typeTable = new HashMap();
    private ClassLoader loader;
    private boolean resolve;
    private List<Type> exceptionTypes;

    public TypeGroup(ClassLoader loader) {
        this.typeTable.put("boolean", Type.Z);
        this.typeTable.put("java.lang.Boolean", Type.BOOLEAN);
        this.typeTable.put("Boolean", Type.BOOLEAN);
        this.typeTable.put("byte", Type.B);
        this.typeTable.put("java.lang.Byte", Type.BYTE);
        this.typeTable.put("Byte", Type.BYTE);
        this.typeTable.put("short", Type.S);
        this.typeTable.put("java.lang.Short", Type.SHORT);
        this.typeTable.put("Short", Type.SHORT);
        this.typeTable.put("char", Type.C);
        this.typeTable.put("java.lang.Char", Type.CHARACTER);
        this.typeTable.put("Char", Type.CHARACTER);
        this.typeTable.put("int", Type.I);
        this.typeTable.put("java.lang.Integer", Type.INTEGER);
        this.typeTable.put("Integer", Type.INTEGER);
        this.typeTable.put("long", Type.J);
        this.typeTable.put("java.lang.Long", Type.LONG);
        this.typeTable.put("Long", Type.LONG);
        this.typeTable.put("float", Type.F);
        this.typeTable.put("java.lang.Float", Type.FLOAT);
        this.typeTable.put("Float", Type.FLOAT);
        this.typeTable.put("double", Type.D);
        this.typeTable.put("java.lang.Double", Type.DOUBLE);
        this.typeTable.put("Double", Type.DOUBLE);
        this.typeTable.put("java.lang.String", Type.STRING);
        this.typeTable.put("String", Type.STRING);
        this.typeTable.put("java.lang.Object", Type.OBJECT);
        this.typeTable.put("Object", Type.OBJECT);
        this.typeTable.put("java.lang.Number", Type.NUMBER);
        this.typeTable.put("Number", Type.NUMBER);
        this.typeTable.put("void", Type.VOID);
        this.loader = loader;
        this.resolve = false;
        this.exceptionTypes = new ArrayList<Type>();
    }

    public Type lookup(String name) {
        return Type.dereference(this.typeTable.get(name));
    }

    public Type create(String name) {
        if (name.endsWith("[]")) {
            String baseName = name.substring(0, name.length() - 2);
            Type baseType = this.create(baseName);
            return this.createArray(baseType);
        }
        return this.create(name, null);
    }

    public Type create(String name, Class clazz) {
        Type existing = this.typeTable.get(name);
        if (existing != null) {
            if (clazz != null) {
                if (clazz == Type.dereference(existing).getTargetClass()) {
                    return existing;
                }
                return null;
            }
            return existing;
        }
        if (clazz == null && this.resolve) {
            try {
                clazz = this.loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && name.indexOf(46) < 0) {
            try {
                String newName = "java.lang." + name;
                clazz = this.loader.loadClass(newName);
                name = newName;
            }
            catch (ClassNotFoundException newName) {
                // empty catch block
            }
        }
        Type newType = new Type(name, clazz);
        this.checkAlias(newType);
        this.typeTable.put(name, newType);
        return newType;
    }

    public void resolveTypes() {
        for (Type type : this.typeTable.values()) {
            if (!type.isUndefined()) continue;
            type.resolve(this.loader);
        }
        this.resolve = true;
    }

    private boolean checkAlias(Type type) {
        String name = type.getName();
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx >= 0) {
            Type alias = this.typeTable.get(name = name.substring(dotIdx + 1));
            if (alias != null) {
                return alias.aliasTo(type);
            }
            alias = new Type(name);
            alias.aliasTo(type);
            this.typeTable.put(name, alias);
        }
        return true;
    }

    public Type createArray(Type baseType) {
        String arrayTypeName = baseType.getName() + "[]";
        Type arrayType = this.typeTable.get(arrayTypeName);
        if (arrayType == null) {
            Class<?> arrayClazz = null;
            if (baseType.isPrimitive() || baseType.isDefined()) {
                try {
                    String internalName = "[" + baseType.getInternalName(true, false);
                    arrayClazz = Class.forName(internalName, false, this.loader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            arrayType = baseType.arrayType(arrayClazz);
        }
        return arrayType;
    }

    public void addExceptionTypes(String[] exceptionTypeNames) {
        for (String exceptionTypeName : exceptionTypeNames) {
            this.exceptionTypes.add(this.create(TypeHelper.internalizeClass(exceptionTypeName)));
        }
    }

    public List<Type> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public Type ensureType(Class clazz) {
        if (clazz.isArray()) {
            Class<?> baseClazz = clazz.getComponentType();
            Type baseType = this.ensureType(baseClazz);
            return this.createArray(baseType);
        }
        if (clazz.isPrimitive()) {
            return this.typeTable.get(clazz.getName());
        }
        String name = clazz.getCanonicalName();
        Type type = this.typeTable.get(name);
        if (type == null) {
            type = this.create(name, clazz);
        }
        return type;
    }

    public Type match(String[] path) {
        String name = path[0];
        Type type = this.typeTable.get(name);
        if (type != null) {
            return Type.dereference(type);
        }
        name = "java.lang." + name;
        type = this.typeTable.get(name);
        if (type != null) {
            return Type.dereference(type);
        }
        try {
            Class<?> clazz = this.loader.loadClass(name);
            return this.ensureType(clazz);
        }
        catch (ClassNotFoundException clazz) {
            String fullName = "";
            String sepr = "";
            int length = path.length;
            for (int i = 0; i < length; ++i) {
                fullName = fullName + sepr + path[i];
                sepr = ".";
                try {
                    Class<?> clazz2 = this.loader.loadClass(fullName);
                    return this.ensureType(clazz2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
            return null;
        }
    }
}

