/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.extension.byteman.impl.common.IOUtil;

public class BytemanConfiguration {
    public static String BYTEMAN_JAR = "byteman.jar";
    public static String BYTEMAN_SCRIPT = "byteman.script";
    public static String BYTEMAN_CONFIG = "byteman-arquillian.properties";
    public static String BYTEMAN_EXTENSION_NAME = "byteman";
    public static String BYTEMAN_AUTO_INSTALL_AGENT = "autoInstallAgent";
    public static String BYTEMAN_AGENT_PROPERTIES = "agentProperties";
    public static String BYTEMAN_CLIENT_AGENT_PORT = "clientAgentPort";
    public static String BYTEMAN_CONTAINER_AGENT_PORT = "containerAgentPort";
    private Map<String, String> properties;

    public BytemanConfiguration(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean autoInstallAgent() {
        return Boolean.parseBoolean(this.properties.get(BYTEMAN_AUTO_INSTALL_AGENT));
    }

    public String agentProperties() {
        return this.properties.get(BYTEMAN_AGENT_PROPERTIES);
    }

    public int clientAgentPort() {
        String value = this.properties.get(BYTEMAN_CLIENT_AGENT_PORT);
        if (value == null) {
            return 9092;
        }
        return Integer.parseInt(value);
    }

    public int containerAgentPort() {
        String value = this.properties.get(BYTEMAN_CONTAINER_AGENT_PORT);
        if (value == null) {
            return 9091;
        }
        return Integer.parseInt(value);
    }

    public String toString() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Properties tmp = new Properties();
            tmp.putAll(this.properties);
            tmp.store(output, "byteman-auto-added");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toString();
    }

    public static BytemanConfiguration from(ArquillianDescriptor descriptor) {
        return new BytemanConfiguration(BytemanConfiguration.locateBytemanExtension(descriptor));
    }

    public static BytemanConfiguration from(InputStream inputStream) {
        return BytemanConfiguration.from(IOUtil.asUTF8String(inputStream));
    }

    public static BytemanConfiguration from(String properties) {
        return new BytemanConfiguration(BytemanConfiguration.loadPropertiesString(properties));
    }

    private static Map<String, String> locateBytemanExtension(ArquillianDescriptor descriptor) {
        if (descriptor != null) {
            for (ExtensionDef extension : descriptor.getExtensions()) {
                if (!BYTEMAN_EXTENSION_NAME.equalsIgnoreCase(extension.getExtensionName())) continue;
                return extension.getExtensionProperties();
            }
        }
        return new HashMap<String, String>();
    }

    private static Map<String, String> loadPropertiesString(String properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = new Properties();
        try {
            props.load(new StringReader(properties));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }
}

