/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.ArchiveReport;
import org.jboss.tattletale.reporting.Dump;

public class JarReport
extends ArchiveReport {
    private static final String DIRECTORY = "jar";
    private String filename;

    public JarReport(Archive archive) {
        super(DIRECTORY, 0, archive);
        StringBuffer sb = new StringBuffer(archive.getName());
        this.setFilename(sb.append(".html").toString());
    }

    public String getDirectory() {
        return DIRECTORY;
    }

    BufferedWriter getBufferedWriter() throws IOException {
        return this.getBufferedWriter(this.getFilename());
    }

    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Name</td>" + Dump.NEW_LINE);
        bw.write("     <td>" + this.archive.getName() + "</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Class Version</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        if (50 == this.archive.getVersion()) {
            bw.write("Java 6");
        } else if (49 == this.archive.getVersion()) {
            bw.write("Java 5");
        } else if (48 == this.archive.getVersion()) {
            bw.write("J2SE 1.4");
        } else if (47 == this.archive.getVersion()) {
            bw.write("J2SE 1.3");
        } else if (46 == this.archive.getVersion()) {
            bw.write("J2SE 1.2");
        } else if (45 == this.archive.getVersion()) {
            bw.write("JSE 1.0 / JSE 1.1");
        }
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Locations</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        bw.write("       <table>" + Dump.NEW_LINE);
        for (Location location : this.archive.getLocations()) {
            bw.write("      <tr>" + Dump.NEW_LINE);
            bw.write("        <td>" + location.getFilename() + "</td>" + Dump.NEW_LINE);
            bw.write("        <td>");
            if (location.getVersion() != null) {
                bw.write(location.getVersion());
            } else {
                bw.write("<i>Not listed</i>");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("      </tr>" + Dump.NEW_LINE);
        }
        bw.write("       </table>" + Dump.NEW_LINE);
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Profiles</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        if (this.archive.getProfiles() != null) {
            Iterator pit = this.archive.getProfiles().iterator();
            while (pit.hasNext()) {
                String p = (String)pit.next();
                bw.write(p);
                if (!pit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Manifest</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        if (this.archive.getManifest() != null) {
            Iterator<String> mit = this.archive.getManifest().iterator();
            while (mit.hasNext()) {
                String m = mit.next();
                bw.write(m);
                if (!mit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Signing information</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        if (this.archive.getSign() != null) {
            Iterator<String> sit = this.archive.getSign().iterator();
            while (sit.hasNext()) {
                String s = sit.next();
                bw.write(s);
                if (!sit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Requires</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        Iterator rit = this.archive.getRequires().iterator();
        while (rit.hasNext()) {
            String require = (String)rit.next();
            bw.write(require);
            if (!rit.hasNext()) continue;
            bw.write("<br>");
        }
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Provides</td>" + Dump.NEW_LINE);
        bw.write("     <td>");
        bw.write("       <table>");
        for (Map.Entry<String, Long> entry : this.archive.getProvides().entrySet()) {
            String name = entry.getKey();
            Long serialVersionUID = entry.getValue();
            bw.write("         <tr>" + Dump.NEW_LINE);
            bw.write("           <td>" + name + "</td>" + Dump.NEW_LINE);
            if (serialVersionUID != null) {
                bw.write("           <td>" + serialVersionUID + "</td>" + Dump.NEW_LINE);
            } else {
                bw.write("           <td>&nbsp;</td>" + Dump.NEW_LINE);
            }
            bw.write("         </tr>" + Dump.NEW_LINE);
        }
        bw.write("       </table>");
        bw.write("</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("</table>" + Dump.NEW_LINE);
    }

    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>" + this.archive.getName() + "</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }

    private String getFilename() {
        return this.filename;
    }

    private void setFilename(String filename) {
        this.filename = filename;
    }
}

