/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveDependsOnReport
extends CLSReport {
    private static final String NAME = "Transitive Depends On";
    private static final String DIRECTORY = "transitivedependson";

    public TransitiveDependsOnReport(SortedSet<Archive> archives, List<Archive> known, String classloaderStructure) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY, classloaderStructure, known);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Depends On</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        TreeMap<String, SortedSet<String>> dependsOnMap = new TreeMap<String, SortedSet<String>>();
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            TreeSet<String> result = (TreeSet<String>)dependsOnMap.get(archive.getName());
            if (result == null) {
                result = new TreeSet<String>();
            }
            for (String require : archive.getRequires()) {
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (a.getType() != 0 || !a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
                if (!found) {
                    Iterator<Archive> kit = this.getKnown().iterator();
                    while (!found && kit.hasNext()) {
                        Archive a = kit.next();
                        if (!a.doesProvide(require)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                result.add(require);
            }
            dependsOnMap.put(archive.getName(), result);
        }
        TreeMap<String, TreeSet<String>> transitiveDependsOnMap = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry entry : dependsOnMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            TreeSet<String> result = new TreeSet<String>();
            if (value != null && value.size() > 0) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, archive, dependsOnMap, result);
                }
            }
            transitiveDependsOnMap.put(archive, result);
        }
        boolean odd = true;
        for (Map.Entry entry : transitiveDependsOnMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive + ".html\">" + archive + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            if (value.size() == 0) {
                bw.write("&nbsp;");
            } else {
                Iterator valueIt = value.iterator();
                while (valueIt.hasNext()) {
                    String r = (String)valueIt.next();
                    if (r.endsWith(".jar")) {
                        bw.write("<a href=\"../jar/" + r + ".html\">" + r + "</a>");
                    } else if (!this.isFiltered(archive, r)) {
                        bw.write("<i>" + r + "</i>");
                        this.status = 1;
                    } else {
                        bw.write("<i style=\"text-decoration: line-through;\">" + r + "</i>");
                    }
                    if (!valueIt.hasNext()) continue;
                    bw.write(", ");
                }
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Transitive Depends On</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }

    private void resolveDependsOn(String scanArchive, String archive, SortedMap<String, SortedSet<String>> map, SortedSet<String> result) {
        if (!archive.equals(scanArchive) && !result.contains(scanArchive)) {
            result.add(scanArchive);
            SortedSet value = (SortedSet)map.get(scanArchive);
            if (value != null) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, archive, map, result);
                }
            }
        }
    }
}

