/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuppressWarningsHolder
extends Check {
    public static final String CHECKSTYLE_PREFIX = "checkstyle:";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final String CHECK_SUFFIX = "Check";
    private static final Map<String, String> CHECK_ALIAS_MAP = new HashMap<String, String>();
    private static final ThreadLocal<List<Entry>> ENTRIES = new ThreadLocal();

    public static String getDefaultAlias(String aSourceName) {
        int startIndex = aSourceName.lastIndexOf(46) + 1;
        int endIndex = aSourceName.length();
        if (aSourceName.endsWith(CHECK_SUFFIX)) {
            endIndex -= CHECK_SUFFIX.length();
        }
        return aSourceName.substring(startIndex, endIndex).toLowerCase();
    }

    public static String getAlias(String aSourceName) {
        String checkAlias = CHECK_ALIAS_MAP.get(aSourceName);
        if (checkAlias == null) {
            checkAlias = SuppressWarningsHolder.getDefaultAlias(aSourceName);
        }
        return checkAlias;
    }

    public static void registerAlias(String aSourceName, String aCheckAlias) {
        CHECK_ALIAS_MAP.put(aSourceName, aCheckAlias);
    }

    public void setAliasList(String aAliasList) {
        for (String sourceAlias : aAliasList.split(",")) {
            int index = sourceAlias.indexOf("=");
            if (index > 0) {
                SuppressWarningsHolder.registerAlias(sourceAlias.substring(0, index), sourceAlias.substring(index + 1));
                continue;
            }
            if (sourceAlias.length() <= 0) continue;
            throw new ConversionException("'=' expected in alias list item: " + sourceAlias);
        }
    }

    public static boolean isSuppressed(String aSourceName, int aLine, int aColumn) {
        List<Entry> entries = ENTRIES.get();
        String checkAlias = SuppressWarningsHolder.getAlias(aSourceName);
        if (entries != null && checkAlias != null) {
            for (Entry entry : entries) {
                boolean afterStart = entry.getFirstLine() < aLine || entry.getFirstLine() == aLine && entry.getFirstColumn() <= aColumn;
                boolean beforeEnd = entry.getLastLine() > aLine || entry.getLastLine() == aLine && entry.getLastColumn() >= aColumn;
                boolean nameMatches = entry.getCheckName().equals(checkAlias);
                if (!afterStart || !beforeEnd || !nameMatches) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        ENTRIES.set(new LinkedList());
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String identifier = SuppressWarningsHolder.getIdentifier(SuppressWarningsHolder.getNthChild(aAST, 1));
        if (identifier.startsWith(JAVA_LANG_PREFIX)) {
            identifier = identifier.substring(JAVA_LANG_PREFIX.length());
        }
        if ("SuppressWarnings".equals(identifier)) {
            int lastColumn;
            int lastLine;
            DetailAST nextAST;
            List<String> values = null;
            DetailAST lparenAST = aAST.findFirstToken(76);
            if (lparenAST != null && (nextAST = lparenAST.getNextSibling()) != null) {
                int nextType = nextAST.getType();
                switch (nextType) {
                    case 28: 
                    case 162: {
                        values = SuppressWarningsHolder.getAnnotationValues(nextAST);
                        break;
                    }
                    case 160: {
                        values = SuppressWarningsHolder.getAnnotationValues(SuppressWarningsHolder.getNthChild(nextAST, 2));
                        break;
                    }
                    case 77: {
                        break;
                    }
                }
            }
            if (values == null) {
                this.log(aAST, "suppress.warnings.missing.value", new Object[0]);
                return;
            }
            DetailAST targetAST = null;
            DetailAST parentAST = aAST.getParent();
            if (parentAST != null) {
                block5 : switch (parentAST.getType()) {
                    case 5: 
                    case 158: {
                        parentAST = parentAST.getParent();
                        if (parentAST == null) break;
                        switch (parentAST.getType()) {
                            case 8: 
                            case 9: 
                            case 10: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 21: 
                            case 154: {
                                targetAST = parentAST;
                                break block5;
                            }
                        }
                        break;
                    }
                }
            }
            if (targetAST == null) {
                this.log(aAST, "suppress.warnings.invalid.target", new Object[0]);
            }
            int firstLine = targetAST.getLineNo();
            int firstColumn = targetAST.getColumnNo();
            DetailAST nextAST2 = targetAST.getNextSibling();
            if (nextAST2 != null) {
                lastLine = nextAST2.getLineNo();
                lastColumn = nextAST2.getColumnNo() - 1;
            } else {
                lastLine = Integer.MAX_VALUE;
                lastColumn = Integer.MAX_VALUE;
            }
            List<Entry> entries = ENTRIES.get();
            if (entries != null) {
                for (String value : values) {
                    if (value.startsWith(CHECKSTYLE_PREFIX)) {
                        value = value.substring(CHECKSTYLE_PREFIX.length());
                    }
                    entries.add(new Entry(value, firstLine, firstColumn, lastLine, lastColumn));
                }
            }
        }
    }

    private static DetailAST getNthChild(DetailAST aAST, int aIndex) {
        DetailAST child = aAST.getFirstChild();
        if (child != null) {
            for (int i = 0; i < aIndex && child != null; child = child.getNextSibling(), ++i) {
            }
        }
        return child;
    }

    private static String getIdentifier(DetailAST aAST) {
        if (aAST != null) {
            if (aAST.getType() == 58) {
                return aAST.getText();
            }
            if (aAST.getType() == 59) {
                return SuppressWarningsHolder.getIdentifier(aAST.getFirstChild()) + "." + SuppressWarningsHolder.getIdentifier(aAST.getLastChild());
            }
        }
        throw new IllegalArgumentException("Identifier AST expected: " + aAST);
    }

    private static String getStringExpr(DetailAST aAST) {
        if (aAST != null && aAST.getType() == 28) {
            DetailAST firstChild = aAST.getFirstChild();
            if (firstChild.getType() == 139) {
                String quotedText = firstChild.getText();
                return quotedText.substring(1, quotedText.length() - 1);
            }
            throw new IllegalArgumentException("String literal AST expected: " + firstChild);
        }
        throw new IllegalArgumentException("Expression AST expected: " + aAST);
    }

    private static List<String> getAnnotationValues(DetailAST aAST) {
        switch (aAST.getType()) {
            case 28: {
                return ImmutableList.of(SuppressWarningsHolder.getStringExpr(aAST));
            }
            case 162: {
                LinkedList<String> valueList = Lists.newLinkedList();
                for (DetailAST childAST = aAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                    if (childAST.getType() != 28) continue;
                    valueList.add(SuppressWarningsHolder.getStringExpr(childAST));
                }
                return valueList;
            }
        }
        throw new IllegalArgumentException("Expression or annotation array initializer AST expected: " + aAST);
    }

    private static class Entry {
        private final String mCheckName;
        private final int mFirstLine;
        private final int mFirstColumn;
        private final int mLastLine;
        private final int mLastColumn;

        public Entry(String aCheckName, int aFirstLine, int aFirstColumn, int aLastLine, int aLastColumn) {
            this.mCheckName = aCheckName;
            this.mFirstLine = aFirstLine;
            this.mFirstColumn = aFirstColumn;
            this.mLastLine = aLastLine;
            this.mLastColumn = aLastColumn;
        }

        public String getCheckName() {
            return this.mCheckName;
        }

        public int getFirstLine() {
            return this.mFirstLine;
        }

        public int getFirstColumn() {
            return this.mFirstColumn;
        }

        public int getLastLine() {
            return this.mLastLine;
        }

        public int getLastColumn() {
            return this.mLastColumn;
        }
    }
}

