/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class IDivResultCastToDouble
extends BytecodeScanningDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("idcd.debug");
    private final BugAccumulator bugAccumulator;
    private int prevOpCode;
    SourceLineAnnotation pendingIdivCastToDivBugLocation = null;

    public IDivResultCastToDouble(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("Visiting " + obj);
        }
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (DEBUG) {
            System.out.println("Saw opcode " + OPCODE_NAMES[seen] + " " + this.pendingIdivCastToDivBugLocation);
        }
        if ((this.prevOpCode == 135 || this.prevOpCode == 138) && seen == 184 && ClassName.isMathClass(this.getClassConstantOperand()) && this.getNameConstantOperand().equals("ceil")) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_INT_CAST_TO_DOUBLE_PASSED_TO_CEIL", 1).addClassAndMethod(this), this);
            this.pendingIdivCastToDivBugLocation = null;
        } else if ((this.prevOpCode == 134 || this.prevOpCode == 137) && seen == 184 && ClassName.isMathClass(this.getClassConstantOperand()) && this.getNameConstantOperand().equals("round")) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_INT_CAST_TO_FLOAT_PASSED_TO_ROUND", 2).addClassAndMethod(this), this);
            this.pendingIdivCastToDivBugLocation = null;
        } else if (this.pendingIdivCastToDivBugLocation != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_IDIV_CAST_TO_DOUBLE", 2).addClassAndMethod(this), this.pendingIdivCastToDivBugLocation);
            this.pendingIdivCastToDivBugLocation = null;
        }
        if (this.prevOpCode == 108 && (seen == 135 || seen == 134) || this.prevOpCode == 109 && (seen == 138 || seen == 137)) {
            this.pendingIdivCastToDivBugLocation = SourceLineAnnotation.fromVisitedInstruction(this);
        }
        this.prevOpCode = seen;
    }
}

