/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jdepend.framework.JDependTestCase;
import jdepend.framework.PackageFilter;

public class FilterTest
extends JDependTestCase {
    public FilterTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        System.setProperty("user.home", this.getTestDataDir());
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testDefault() {
        PackageFilter filter = new PackageFilter();
        FilterTest.assertEquals((int)5, (int)filter.getFilters().size());
        this.assertFiltersExist(filter);
    }

    public void testFile() throws IOException {
        String filterFile = this.getTestDataDir() + "jdepend.properties";
        PackageFilter filter = new PackageFilter(new File(filterFile));
        FilterTest.assertEquals((int)5, (int)filter.getFilters().size());
        this.assertFiltersExist(filter);
    }

    public void testCollection() throws IOException {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("java.*");
        filters.add("javax.*");
        filters.add("sun.*");
        filters.add("com.sun.*");
        filters.add("com.xyz.tests.*");
        PackageFilter filter = new PackageFilter(filters);
        FilterTest.assertEquals((int)5, (int)filter.getFilters().size());
        this.assertFiltersExist(filter);
    }

    public void testCollectionSubset() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("com.xyz");
        PackageFilter filter = new PackageFilter(filters);
        FilterTest.assertEquals((int)1, (int)filter.getFilters().size());
    }

    private void assertFiltersExist(PackageFilter filter) {
        FilterTest.assertFalse((boolean)filter.accept("java.lang"));
        FilterTest.assertFalse((boolean)filter.accept("javax.ejb"));
        FilterTest.assertTrue((boolean)filter.accept("com.xyz.tests"));
        FilterTest.assertFalse((boolean)filter.accept("com.xyz.tests.a"));
        FilterTest.assertTrue((boolean)filter.accept("com.xyz.ejb"));
    }
}

