/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.highlight.renderer;

import com.uwyn.jhighlight.highlighter.JavaHighlighter;
import com.uwyn.jhighlight.highlighter.XmlHighlighter;
import com.uwyn.jhighlight.tools.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FORenderer {
    private List<String> styles = new ArrayList<String>();
    private List<String> tokens = new ArrayList<String>();
    private static int caller = 0;
    private static Map<Integer, List<String>> allStyles = new HashMap<Integer, List<String>>();
    private static Map<Integer, List<String>> allTokens = new HashMap<Integer, List<String>>();

    public static int getNoOfTokens(int caller) {
        return allTokens.get(caller).size();
    }

    public static String getStyle(int caller, int index) {
        List<String> styles = allStyles.get(caller);
        if (styles.size() > 0) {
            return styles.get(index);
        }
        return "";
    }

    public static String getToken(int caller, int index) {
        List<String> tokens = allTokens.get(caller);
        if (tokens.size() > 0) {
            return tokens.get(index);
        }
        return "";
    }

    public static boolean isParsable(String role) {
        return role.equals("JAVA") || role.equals("XML");
    }

    public int parseText(String role, String text, String encoding) throws IOException {
        this.styles.clear();
        this.tokens.clear();
        StringBufferInputStream in = new StringBufferInputStream(text);
        JavaHighlighter highlighter = null;
        if (role.equals("JAVA")) {
            highlighter = new JavaHighlighter();
            JavaHighlighter.ASSERT_IS_KEYWORD = true;
        } else if (role.equals("XML")) {
            highlighter = new XmlHighlighter();
        } else {
            return 0;
        }
        InputStreamReader isr = encoding == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, encoding);
        BufferedReader r = new BufferedReader(isr);
        StringBuffer buf = new StringBuffer();
        int c = 0;
        while ((c = r.read()) != -1) {
            buf.append((char)c);
        }
        String allLines = buf.toString();
        String[] lines = allLines.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int length;
            String line = lines[i];
            if (i != lines.length - 1 || i == lines.length - 1 && allLines.endsWith("\n")) {
                line = line + "\n";
            }
            line = StringUtils.convertTabsToSpaces((String)line, (int)4);
            StringReader lineReader = new StringReader(line);
            highlighter.setReader((Reader)lineReader);
            for (int index = 0; index < line.length(); index += length) {
                byte style = highlighter.getNextToken();
                length = highlighter.getTokenLength();
                String token = line.substring(index, index + length);
                this.styles.add(this.getCssClass(role, style));
                this.tokens.add(token);
            }
        }
        allStyles.put(caller, this.styles);
        allTokens.put(caller, this.tokens);
        return caller++;
    }

    protected String getCssClass(String role, int style) {
        if (role.equals("JAVA")) {
            switch (style) {
                case 1: {
                    return "java_plain";
                }
                case 2: {
                    return "java_keyword";
                }
                case 3: {
                    return "java_type";
                }
                case 4: {
                    return "java_operator";
                }
                case 5: {
                    return "java_separator";
                }
                case 6: {
                    return "java_literal";
                }
                case 7: {
                    return "java_comment";
                }
                case 8: {
                    return "java_javadoc_comment";
                }
                case 9: {
                    return "java_javadoc_tag";
                }
            }
        } else if (role.equals("XML")) {
            switch (style) {
                case 1: {
                    return "xml_plain";
                }
                case 2: {
                    return "xml_char_data";
                }
                case 3: {
                    return "xml_tag_symbols";
                }
                case 4: {
                    return "xml_comment";
                }
                case 5: {
                    return "xml_attribute_value";
                }
                case 6: {
                    return "xml_attribute_name";
                }
                case 7: {
                    return "xml_processing_instruction";
                }
                case 8: {
                    return "xml_tag_name";
                }
                case 9: {
                    return "xml_rife_tag";
                }
                case 10: {
                    return "xml_rife_name";
                }
            }
        }
        return null;
    }
}

