/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

public class StandardDocBookFormatMetadata {
    public static final FormatMetadata PDF = new BasicFormatMetadata("pdf").setStylesheetResource("/fo/docbook.xsl").setFileExtension("pdf").setRequiresImagePathSetting(true).setRequiresImageCopying(false).setDoesChunking(false);
    public static final FormatMetadata XHTML = new BasicFormatMetadata("xhtml").setStylesheetResource("/xhtml/docbook.xsl").setFileExtension("xhtml").setRequiresImagePathSetting(false).setRequiresImageCopying(true).setDoesChunking(false);
    public static final FormatMetadata ECLIPSE = new HtmlBasedFormatMetadata("eclipse").setStylesheetResource("/eclipse/eclipse.xsl");
    public static final FormatMetadata HTML = new HtmlBasedFormatMetadata("html").setStylesheetResource("/html/chunk.xsl");
    public static final FormatMetadata HTML_SINGLE = new HtmlBasedFormatMetadata("html_single").setStylesheetResource("/html/docbook.xsl").setDoesChunking(false);
    public static final FormatMetadata HTMLHELP = new HtmlBasedFormatMetadata("htmlhelp").setStylesheetResource("/htmlhelp/htmlhelp.xsl");
    public static final FormatMetadata JAVAHELP = new HtmlBasedFormatMetadata("javahelp").setStylesheetResource("/javahelp/javahelp.xsl");
    public static final FormatMetadata MAN = new HtmlBasedFormatMetadata("man").setStylesheetResource("/manpages/docbook.xsl").setDoesChunking(false);
    public static final FormatMetadata WEBSITE = new HtmlBasedFormatMetadata("website").setStylesheetResource("/website/website.xsl").setDoesChunking(false);

    public static FormatMetadata getFormatMetadata(String name) {
        if (ECLIPSE.getName().equals(name)) {
            return ECLIPSE;
        }
        if (HTML.getName().equals(name)) {
            return HTML;
        }
        if (HTML_SINGLE.getName().equals(name)) {
            return HTML_SINGLE;
        }
        if (HTMLHELP.getName().equals(name)) {
            return HTMLHELP;
        }
        if (JAVAHELP.getName().equals(name)) {
            return JAVAHELP;
        }
        if (MAN.getName().equals(name)) {
            return MAN;
        }
        if (PDF.getName().equals(name)) {
            return PDF;
        }
        if (WEBSITE.getName().equals(name)) {
            return WEBSITE;
        }
        if (XHTML.getName().equals(name)) {
            return XHTML;
        }
        return null;
    }

    private static class HtmlBasedFormatMetadata
    extends BasicFormatMetadata {
        private HtmlBasedFormatMetadata(String name) {
            super(name);
            this.setDoesChunking(true);
            this.setFileExtension("html");
            this.setRequiresImagePathSetting(false);
            this.setRequiresImageCopying(true);
        }
    }

    private static class BasicFormatMetadata
    implements FormatMetadata {
        private final String name;
        private String stylesheetResource;
        private String fileExtension;
        private boolean requiresImagePathSetting;
        private boolean requiresImageCopying;
        private boolean doesChunking;

        private BasicFormatMetadata(String name) {
            this.name = name;
            this.requiresImagePathSetting = true;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getStylesheetResource() {
            return this.stylesheetResource;
        }

        @Override
        public String getFileExtension() {
            return this.fileExtension;
        }

        @Override
        public boolean requiresImagePathSetting() {
            return this.requiresImagePathSetting;
        }

        @Override
        public boolean requiresImageCopying() {
            return this.requiresImageCopying;
        }

        @Override
        public boolean doesChunking() {
            return this.doesChunking;
        }

        BasicFormatMetadata setStylesheetResource(String stylesheetResource) {
            this.stylesheetResource = stylesheetResource;
            return this;
        }

        BasicFormatMetadata setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        BasicFormatMetadata setRequiresImagePathSetting(boolean requiresImagePathSetting) {
            this.requiresImagePathSetting = requiresImagePathSetting;
            return this;
        }

        BasicFormatMetadata setRequiresImageCopying(boolean requiresImageCopying) {
            this.requiresImageCopying = requiresImageCopying;
            return this;
        }

        BasicFormatMetadata setDoesChunking(boolean doesChunking) {
            this.doesChunking = doesChunking;
            return this;
        }
    }

    public static interface FormatMetadata {
        public String getName();

        public String getStylesheetResource();

        public String getFileExtension();

        public boolean requiresImagePathSetting();

        public boolean requiresImageCopying();

        public boolean doesChunking();
    }
}

