/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class IteratorIdioms
extends BytecodeScanningDetector
implements StatelessDetector {
    private final ClassDescriptor iteratorDescriptor = DescriptorFactory.createClassDescriptor(Iterator.class);
    private final BugReporter bugReporter;
    private boolean sawNoSuchElement;
    private boolean sawCall;
    private boolean shouldVisitCode;

    public IteratorIdioms(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        try {
            if (subtypes2.isSubtype(classContext.getClassDescriptor(), this.iteratorDescriptor)) {
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }

    @Override
    public void visit(Method method) {
        if (method.isPublic() && method.getName().equals("next") && method.getArgumentTypes().length == 0) {
            this.shouldVisitCode = true;
            super.visit(method);
        } else {
            this.shouldVisitCode = false;
        }
    }

    @Override
    public void visit(Code obj) {
        if (!this.shouldVisitCode) {
            return;
        }
        this.sawNoSuchElement = false;
        this.sawCall = false;
        super.visit(obj);
        if (!this.sawNoSuchElement) {
            BugInstance bug = new BugInstance(this, "IT_NO_SUCH_ELEMENT", this.sawCall ? 3 : 2);
            bug.addClassAndMethod(this);
            this.bugReporter.reportBug(bug);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 187 && this.getClassConstantOperand().equals("java/util/NoSuchElementException")) {
            this.sawNoSuchElement = true;
        } else if (seen == 183 || seen == 182 || seen == 185) {
            this.sawCall = true;
            String name = this.getNameConstantOperand().toLowerCase();
            if (name.indexOf("next") >= 0 || name.indexOf("previous") >= 0) {
                this.sawNoSuchElement = true;
            }
        }
    }
}

