/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.bcel.classfile.Code;

public class PreferZeroLengthArrays
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean nullOnTOS = false;
    private final BugReporter bugReporter;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();

    public PreferZeroLengthArrays(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.found.clear();
        if (this.getMethodName().equals("listFiles")) {
            return;
        }
        String returnType = this.getMethodSig().substring(this.getMethodSig().indexOf(41) + 1);
        if (returnType.startsWith("[")) {
            this.nullOnTOS = false;
            super.visit(obj);
            if (!this.found.isEmpty()) {
                BugInstance bug = new BugInstance(this, "PZLA_PREFER_ZERO_LENGTH_ARRAYS", 3).addClassAndMethod(this);
                for (SourceLineAnnotation s : this.found) {
                    bug.add(s);
                }
                this.bugReporter.reportBug(bug);
                this.found.clear();
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 1: {
                this.nullOnTOS = true;
                return;
            }
            case 176: {
                SourceLineAnnotation sourceLineAnnotation;
                if (!this.nullOnTOS || (sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.getPC())) == null) break;
                this.found.add(sourceLineAnnotation);
                break;
            }
        }
        this.nullOnTOS = false;
    }
}

