/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Code;

public class WaitInLoop
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean sawWait = false;
    boolean sawAwait = false;
    boolean waitHasTimeout = false;
    boolean sawNotify = false;
    int notifyPC;
    int earliestJump = 0;
    int waitAt = 0;
    private final BugReporter bugReporter;

    public WaitInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.sawWait = false;
        this.sawAwait = false;
        this.waitHasTimeout = false;
        this.sawNotify = false;
        this.earliestJump = 9999999;
        super.visit(obj);
        if ((this.sawWait || this.sawAwait) && this.waitAt < this.earliestJump) {
            String bugType = this.sawWait ? "WA_NOT_IN_LOOP" : "WA_AWAIT_NOT_IN_LOOP";
            this.bugReporter.reportBug(new BugInstance(this, bugType, this.waitHasTimeout ? 3 : 2).addClassAndMethod(this).addSourceLine(this, this.waitAt));
        }
        if (this.sawNotify) {
            this.bugReporter.reportBug(new BugInstance(this, "NO_NOTIFY_NOT_NOTIFYALL", 3).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if ((seen == 182 || seen == 185) && this.getNameConstantOperand().equals("notify") && this.getSigConstantOperand().equals("()V")) {
            this.sawNotify = true;
            this.notifyPC = this.getPC();
        }
        if (!(this.sawWait || this.sawAwait || seen != 182 && seen != 185 || !this.isMonitorWait() && !this.isConditionAwait())) {
            if (this.getNameConstantOperand().equals("wait")) {
                this.sawWait = true;
            } else {
                this.sawAwait = true;
            }
            this.waitHasTimeout = !this.getSigConstantOperand().equals("()V");
            this.waitAt = this.getPC();
            this.earliestJump = this.getPC() + 1;
            return;
        }
        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
            this.earliestJump = Math.min(this.earliestJump, this.getBranchTarget());
        }
    }

    private boolean isConditionAwait() {
        String className = this.getClassConstantOperand();
        String name = this.getNameConstantOperand();
        String sig = this.getSigConstantOperand();
        if (!className.equals("java/util/concurrent/locks/Condition")) {
            return false;
        }
        if (!name.startsWith("await")) {
            return false;
        }
        if (name.equals("await") && (sig.equals("()V") || sig.equals("(JLjava/util/concurrent/TimeUnit;)V"))) {
            return true;
        }
        if (name.equals("awaitNanos") && sig.equals("(J)V")) {
            return true;
        }
        if (name.equals("awaitUninterruptibly") && sig.equals("()V")) {
            return true;
        }
        return name.equals("awaitUntil") && sig.equals("(Ljava/util/Date;)V");
    }

    private boolean isMonitorWait() {
        String name = this.getNameConstantOperand();
        String sig = this.getSigConstantOperand();
        return name.equals("wait") && (sig.equals("()V") || sig.equals("(J)V") || sig.equals("(JI)V"));
    }
}

