/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MemberMatcher;
import edu.umd.cs.findbugs.filter.SignatureUtil;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class FieldMatcher
extends MemberMatcher
implements Matcher {
    public FieldMatcher(String name) {
        super(name);
    }

    public FieldMatcher(String name, String type) {
        super(name, SignatureUtil.createFieldSignature(type));
    }

    @Override
    public String toString() {
        return "Method(" + super.toString() + ")";
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        FieldAnnotation fieldAnnotation = null;
        if (this.role == null || this.role.equals("")) {
            fieldAnnotation = bugInstance.getPrimaryField();
        } else {
            for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
                if (!(bugAnnotation instanceof FieldAnnotation) || !this.role.equals(bugAnnotation.getDescription())) continue;
                fieldAnnotation = (FieldAnnotation)bugAnnotation;
                break;
            }
        }
        if (fieldAnnotation == null) {
            return false;
        }
        if (!this.name.match(fieldAnnotation.getFieldName())) {
            return false;
        }
        return this.signature == null || this.signature.match(fieldAnnotation.getFieldSignature());
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.name.getSpec());
        if (this.signature != null) {
            attributes.addOptionalAttribute("signature", this.signature.getSpec());
        }
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Field", attributes);
    }
}

