/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.util.Bag;
import java.util.ArrayList;
import java.util.Map;

public class TestingGround {
    BugCollection bugCollection;

    public TestingGround() {
    }

    public TestingGround(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public TestingGround execute() {
        ProjectPackagePrefixes foo = new ProjectPackagePrefixes();
        for (BugInstance b : this.bugCollection.getCollection()) {
            foo.countBug(b);
        }
        foo.report();
        return this;
    }

    public static void main(String[] args) throws Exception {
        int buried;
        DetectorFactoryCollection.instance();
        CommandLine commandLine = new CommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + TestingGround.class.getName() + " [options] [<xml results>] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        ArrayList live = new ArrayList();
        ArrayList died = new ArrayList();
        Bag<String> allBugs = new Bag<String>();
        int i = 0;
        while ((long)i <= bugCollection.getSequenceNumber()) {
            live.add(new Bag());
            died.add(new Bag());
            ++i;
        }
        for (BugInstance b : bugCollection) {
            int n = (int)b.getFirstVersion();
            buried = (int)b.getLastVersion() + 1;
            int finish = buried;
            if (finish == 0) {
                finish = (int)bugCollection.getSequenceNumber();
            }
            String bugPattern = b.getBugPattern().getType();
            allBugs.add(bugPattern);
            for (int i2 = n; i2 <= finish; ++i2) {
                ((Bag)live.get(i2)).add(bugPattern);
            }
            if (buried <= 0) continue;
            ((Bag)died.get(buried)).add(bugPattern);
        }
        i = 0;
        while ((long)i < bugCollection.getSequenceNumber()) {
            for (Map.Entry entry : ((Bag)died.get(i)).entrySet()) {
                Integer buried2 = (Integer)entry.getValue();
                int total = ((Bag)live.get(i)).getCount(entry.getKey());
                if (buried2 <= 30 || buried2 * 3 <= total) continue;
                System.out.printf("%d/%d died at %d for %s%n", buried2, total, i, entry.getKey());
            }
            ++i;
        }
        SortedBugCollection results = bugCollection.createEmptyCollectionWithMetadata();
        for (BugInstance bugInstance : bugCollection) {
            int survied;
            buried = (int)bugInstance.getLastVersion() + 1;
            String bugPattern = bugInstance.getBugPattern().getType();
            if (buried > 0) {
                int buriedCount = ((Bag)died.get(buried)).getCount(bugPattern);
                int total = ((Bag)live.get(buried)).getCount(bugPattern);
                if (buriedCount > 30 && buriedCount * 3 > total) continue;
            }
            if ((survied = ((Bag)live.get((int)bugCollection.getSequenceNumber())).getCount(bugPattern)) == 0 && allBugs.getCount(bugPattern) > 100) continue;
            results.add(bugInstance, false);
        }
        if (argCount == args.length) {
            results.writeXML(System.out);
        } else {
            results.writeXML(args[argCount++]);
        }
    }

    static class CommandLine
    extends edu.umd.cs.findbugs.config.CommandLine {
        CommandLine() {
        }

        @Override
        public void handleOption(String option, String optionalExtraPart) {
            throw new IllegalArgumentException("unknown option: " + option);
        }

        @Override
        public void handleOptionWithArgument(String option, String argument) {
            throw new IllegalArgumentException("unknown option: " + option);
        }
    }
}

