/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportOrderOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOrderCheck
extends AbstractOptionCheck<ImportOrderOption> {
    private static final String WILDCARD_GROUP_NAME = "*";
    private Pattern[] mGroups = new Pattern[0];
    private boolean mSeparated;
    private boolean mOrdered = true;
    private boolean mCaseSensitive = true;
    private int mLastGroup;
    private int mLastImportLine;
    private String mLastImport;
    private boolean mLastImportStatic;
    private boolean mBeforeFirstImport;

    public ImportOrderCheck() {
        super(ImportOrderOption.UNDER, ImportOrderOption.class);
    }

    public void setGroups(String[] aGroups) {
        this.mGroups = new Pattern[aGroups.length];
        for (int i = 0; i < aGroups.length; ++i) {
            Pattern grp;
            String pkg = aGroups[i];
            if (WILDCARD_GROUP_NAME.equals(pkg)) {
                grp = Pattern.compile("");
            } else if (pkg.startsWith("/")) {
                if (!pkg.endsWith("/")) {
                    throw new IllegalArgumentException("Invalid group");
                }
                pkg = pkg.substring(1, pkg.length() - 1);
                grp = Pattern.compile(pkg);
            } else {
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                grp = Pattern.compile("^" + Pattern.quote(pkg));
            }
            this.mGroups[i] = grp;
        }
    }

    public void setOrdered(boolean aOrdered) {
        this.mOrdered = aOrdered;
    }

    public void setSeparated(boolean aSeparated) {
        this.mSeparated = aSeparated;
    }

    public void setCaseSensitive(boolean aCaseSensitive) {
        this.mCaseSensitive = aCaseSensitive;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mLastGroup = Integer.MIN_VALUE;
        this.mLastImportLine = Integer.MIN_VALUE;
        this.mLastImport = "";
        this.mLastImportStatic = false;
        this.mBeforeFirstImport = true;
    }

    @Override
    public void visitToken(DetailAST aAST) {
        boolean isStatic;
        FullIdent ident;
        if (aAST.getType() == 30) {
            ident = FullIdent.createFullIdentBelow(aAST);
            isStatic = false;
        } else {
            ident = FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling());
            isStatic = true;
        }
        switch ((ImportOrderOption)((Object)this.getAbstractOption())) {
            case TOP: {
                if (!isStatic && this.mLastImportStatic) {
                    this.mLastGroup = Integer.MIN_VALUE;
                    this.mLastImport = "";
                }
            }
            case ABOVE: {
                this.doVisitToken(ident, isStatic, !this.mLastImportStatic && isStatic);
                break;
            }
            case INFLOW: {
                this.doVisitToken(ident, isStatic, true);
                break;
            }
            case BOTTOM: {
                if (isStatic && !this.mLastImportStatic) {
                    this.mLastGroup = Integer.MIN_VALUE;
                    this.mLastImport = "";
                }
            }
            case UNDER: {
                this.doVisitToken(ident, isStatic, this.mLastImportStatic && !isStatic);
                break;
            }
        }
        this.mLastImportLine = aAST.findFirstToken(45).getLineNo();
        this.mLastImportStatic = isStatic;
        this.mBeforeFirstImport = false;
    }

    private void doVisitToken(FullIdent aIdent, boolean aIsStatic, boolean aPrevious) {
        if (aIdent != null) {
            String name = aIdent.getText();
            int groupIdx = this.getGroupNumber(name);
            int line = aIdent.getLineNo();
            if (groupIdx > this.mLastGroup) {
                if (!this.mBeforeFirstImport && this.mSeparated && line - this.mLastImportLine < 2) {
                    this.log(line, "import.separation", name);
                }
            } else if (groupIdx == this.mLastGroup) {
                this.doVisitTokenInSameGroup(aIsStatic, aPrevious, name, line);
            } else {
                this.log(line, "import.ordering", name);
            }
            this.mLastGroup = groupIdx;
            this.mLastImport = name;
        }
    }

    private void doVisitTokenInSameGroup(boolean aIsStatic, boolean aPrevious, String aName, int aLine) {
        if (!this.mOrdered) {
            return;
        }
        if (((ImportOrderOption)((Object)this.getAbstractOption())).equals((Object)ImportOrderOption.INFLOW)) {
            if (this.compare(this.mLastImport, aName, this.mCaseSensitive) > 0) {
                this.log(aLine, "import.ordering", aName);
            }
        } else {
            boolean shouldFireError;
            boolean bl = shouldFireError = !(this.mLastImportStatic ^ aIsStatic) && this.compare(this.mLastImport, aName, this.mCaseSensitive) > 0 || aPrevious;
            if (shouldFireError) {
                this.log(aLine, "import.ordering", aName);
            }
        }
    }

    private int getGroupNumber(String aName) {
        int bestIndex = this.mGroups.length;
        int bestLength = -1;
        int bestPos = 0;
        for (int i = 0; i < this.mGroups.length; ++i) {
            Matcher matcher = this.mGroups[i].matcher(aName);
            while (matcher.find()) {
                int length = matcher.end() - matcher.start();
                if (length <= bestLength && (length != bestLength || matcher.start() >= bestPos)) continue;
                bestIndex = i;
                bestLength = length;
                bestPos = matcher.start();
            }
        }
        return bestIndex;
    }

    private int compare(String aString1, String aString2, boolean aCaseSensitive) {
        if (aCaseSensitive) {
            return aString1.compareTo(aString2);
        }
        return aString1.compareToIgnoreCase(aString2);
    }
}

