/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.translate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.MasterLanguageDescriptor;
import org.jboss.jdocbook.translate.TranslationSource;
import org.jboss.jdocbook.translate.Translator;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.TranslationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatorImpl
implements Translator {
    private static final Logger log = LoggerFactory.getLogger(TranslatorImpl.class);
    private JDocBookComponentRegistry componentRegistry;

    public TranslatorImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    protected MasterLanguageDescriptor master() {
        return this.componentRegistry.getEnvironment().getMasterLanguageDescriptor();
    }

    private Configuration configuration() {
        return this.componentRegistry.getConfiguration();
    }

    @Override
    public void translate(TranslationSource translationSource) {
        log.debug("Starting translation {}", (Object)this.render(translationSource.getLanguage()));
        for (File file : this.master().getDocumentFiles()) {
            String relativity = FileUtils.determineRelativity(file, this.master().getBaseSourceDirectory());
            File relativeWorkDir = relativity == null ? translationSource.resolveTranslatedXmlDirectory() : new File(translationSource.resolveTranslatedXmlDirectory(), relativity);
            File translatedFile = new File(relativeWorkDir, file.getName());
            if (FileUtils.isXMLFile(file)) {
                String poFileName;
                File relativeTranslationDir = relativity == null ? translationSource.resolvePoDirectory() : new File(translationSource.resolvePoDirectory(), relativity);
                File poFile = new File(relativeTranslationDir, poFileName = TranslationUtils.determinePoFileName(file));
                if (!poFile.exists()) {
                    throw new JDocBookProcessException("Unable to locate PO file for [" + file + "] in [" + translationSource.resolvePoDirectory() + "]");
                }
                this.generateTranslatedXML(file, poFile, translatedFile);
                continue;
            }
            try {
                FileUtils.copyFileToDirectoryIfModified((File)file, (File)translatedFile.getParentFile());
            }
            catch (IOException e) {
                throw new JDocBookProcessException("unable to copy file [ " + file + " ] to directory [ " + translatedFile.getParentFile() + " ]");
            }
        }
    }

    private void generateTranslatedXML(File masterFile, File poFile, File translatedFile) {
        boolean created;
        if (!masterFile.exists()) {
            log.trace("skipping translation; source file did not exist : {}", (Object)masterFile);
            return;
        }
        if (!poFile.exists()) {
            log.trace("skipping translation; PO file did not exist : {}", (Object)poFile);
            return;
        }
        if (translatedFile.exists() && translatedFile.lastModified() >= masterFile.lastModified() && translatedFile.lastModified() >= poFile.lastModified()) {
            log.trace("skipping translation; up-to-date : {0}", (Object)translatedFile);
            return;
        }
        if (!translatedFile.getParentFile().exists() && !(created = translatedFile.getParentFile().mkdirs())) {
            log.info("Unable to create directories for translation");
        }
        CommandLine commandLine = CommandLine.parse((String)"po2xml");
        commandLine.addArgument(FileUtils.resolveFullPathName(masterFile));
        commandLine.addArgument(FileUtils.resolveFullPathName(poFile));
        try {
            FileOutputStream xmlStream = new FileOutputStream(translatedFile);
            DefaultExecutor executor = new DefaultExecutor();
            try {
                PumpStreamHandler streamDirector = new PumpStreamHandler((OutputStream)xmlStream, (OutputStream)System.err);
                executor.setStreamHandler((ExecuteStreamHandler)streamDirector);
                executor.execute(commandLine);
            }
            catch (IOException ioe) {
                throw new JDocBookProcessException("unable to execute po2xml : " + ioe.getMessage());
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for translated XML file [" + translatedFile + "]");
        }
    }

    private String render(Locale language) {
        return TranslationUtils.render(language, this.configuration().getLocaleSeparator());
    }
}

