/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.jdocbook.ResourceDelegate;

public abstract class ResourceDelegateSupport
implements ResourceDelegate {
    protected abstract ClassLoader getResourceClassLoader();

    @Override
    public URL requireResource(String name) {
        URL resource = this.locateResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("could not locate resource [" + name + "]");
        }
        return resource;
    }

    @Override
    public URL locateResource(String name) {
        if (name.startsWith("classpath:")) {
            return this.locateClassPathResource(name.substring(10));
        }
        if (name.startsWith("file:")) {
            try {
                return new URL(name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("malformed explicit file url [" + name + "]");
            }
        }
        return this.locateClassPathResource(name);
    }

    @Override
    public URL locateClassPathResource(String name) {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        URL result = this.getResourceClassLoader().getResource(name);
        if (result == null) {
            result = this.getResourceClassLoader().getResource("/" + name);
        }
        return result;
    }
}

