/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;

public class ProgramPoint {
    public final XMethod method;
    public final int pc;

    public ProgramPoint(BytecodeScanningDetector v) {
        this.method = v.getXMethod();
        this.pc = v.getPC();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + this.pc;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramPoint other = (ProgramPoint)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return this.pc == other.pc;
    }

    public MethodAnnotation getMethodAnnotation() {
        return MethodAnnotation.fromXMethod(this.method);
    }

    public SourceLineAnnotation getSourceLineAnnotation() {
        return SourceLineAnnotation.fromVisitedInstruction(this.method.getMethodDescriptor(), this.pc);
    }

    public String toString() {
        return this.method.toString() + ":" + this.pc;
    }
}

