/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.extension.byteman.api.BMRule;
import org.jboss.arquillian.extension.byteman.api.BMRules;
import org.jboss.arquillian.extension.byteman.api.ExecType;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.extension.byteman.impl.common.GenerateScriptUtil;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public final class ExtractScriptUtil {
    public static String extract(ExecContext context, ClassLifecycleEvent event) {
        BMRule rule = (BMRule)event.getTestClass().getAnnotation(BMRule.class);
        BMRules rules = (BMRules)event.getTestClass().getAnnotation(BMRules.class);
        String script = ExtractScriptUtil.createRules(context, rule, rules);
        context.validate(event);
        return script;
    }

    public static String extract(ExecContext context, TestLifecycleEvent event) {
        BMRule rule = event.getTestMethod().getAnnotation(BMRule.class);
        BMRules rules = event.getTestMethod().getAnnotation(BMRules.class);
        String script = ExtractScriptUtil.createRules(context, rule, rules);
        context.validate(event);
        return script;
    }

    private static String createRules(ExecContext context, BMRule rule, BMRules rules) {
        List<BMRule> bmRules;
        if ((rule != null || rules != null) && (bmRules = ExtractScriptUtil.toRuleList(context, rule, rules)).size() > 0) {
            return GenerateScriptUtil.constructScriptText(bmRules.toArray(new BMRule[bmRules.size()]));
        }
        return null;
    }

    private static List<BMRule> toRuleList(ExecContext context, BMRule rule, BMRules rules) {
        ArrayList<BMRule> bmRules = new ArrayList<BMRule>();
        if (rule != null) {
            ExtractScriptUtil.checkRule(context, bmRules, rule);
        } else {
            for (BMRule bmr : rules.value()) {
                ExtractScriptUtil.checkRule(context, bmRules, bmr);
            }
        }
        return bmRules;
    }

    private static void checkRule(ExecContext context, List<BMRule> bmRules, BMRule rule) {
        ExecType type = rule.exec();
        if (context.match(type)) {
            context.validate(type);
            bmRules.add(rule);
        }
    }
}

