/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.container;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.GenerateScriptUtil;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class AgentInstaller {
    public void install(@Observes(precedence=1) BeforeSuite event) {
        try {
            BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
            if (!config.autoInstallAgent()) {
                return;
            }
            try {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.arquillian.extension.byteman.agent.Main");
                if (!((Boolean)mainClass.getDeclaredField("firstTime").get(null)).booleanValue()) {
                    return;
                }
            }
            catch (ClassNotFoundException mainClass) {
                // empty catch block
            }
            String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            File bytemanHome = File.createTempFile("byteman", "agent");
            bytemanHome.delete();
            bytemanHome.mkdir();
            File bytemanLib = new File(bytemanHome, "lib");
            bytemanLib.mkdirs();
            InputStream bytemanInputJar = Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_JAR);
            File bytemanJar = new File(bytemanLib, BytemanConfiguration.BYTEMAN_JAR);
            GenerateScriptUtil.copy(bytemanInputJar, new FileOutputStream(bytemanJar));
            VirtualMachine vm = VirtualMachine.attach(pid);
            String agentProperties = config.agentProperties();
            vm.loadAgent(bytemanJar.getAbsolutePath(), "listener:true,port:" + config.containerAgentPort() + (agentProperties != null ? ",prop:" + agentProperties : ""));
            vm.detach();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write byteman.jar to disk", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not install byteman agent", e);
        }
    }
}

