/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.binding;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.RuleElement;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.ArrayInitExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.NullLiteral;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Binding
extends RuleElement {
    private static final int HELPER = -1;
    private static final int BIND_VAR = -2;
    private static final int LOCAL_VAR = -3;
    private static final int RETURN_VAR = -4;
    private static final int THROWABLE_VAR = -5;
    private static final int PARAM_COUNT_VAR = -6;
    private static final int PARAM_ARRAY_VAR = -7;
    private static final int INVOKE_PARAM_ARRAY_VAR = -8;
    private String name;
    private String descriptor;
    private Type type;
    private Expression value;
    private int index;
    private int callArrayIndex;
    private int localIndex;
    private Binding alias;
    boolean updated;
    boolean doCheckCast;

    public Binding(Rule rule, String name) {
        this(rule, name, Type.UNDEFINED, null);
    }

    public Binding(Rule rule, String name, Type type) {
        this(rule, name, type, null);
    }

    public Binding(Rule rule, String name, Type type, Expression value) {
        super(rule);
        this.name = name;
        this.type = type != null ? type : Type.UNDEFINED;
        this.value = value;
        this.alias = null;
        this.index = name.matches("\\$[0-9].*") ? Integer.valueOf(name.substring(1)) : (name.equals("$$") ? -1 : (name.equals("$!") ? -4 : (name.equals("$^") ? -5 : (name.equals("$#") ? -6 : (name.equals("$*") ? -7 : (name.equals("$@") ? -8 : (name.equals("$CLASS") ? -9 : (name.equals("$METHOD") ? -10 : (name.matches("\\$[A-Za-z].*") ? -3 : -2)))))))));
        this.callArrayIndex = 0;
        this.updated = false;
        this.doCheckCast = false;
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (this.alias != null) {
            this.type = this.alias.typeCheck(expected);
            this.doCheckCast = this.alias.doCheckCast;
            return this.type;
        }
        if (this.value != null) {
            if (this.type != Type.UNDEFINED) {
                if (this.type.isUndefined() && this.type.getName().indexOf(46) > 0) {
                    throw new TypeException("Binding.typecheck unknown type for binding " + this.name);
                }
                if (Transformer.disallowDowncast()) {
                    Type valueType = this.value.typeCheck(this.type);
                    if (this.type.isUndefined()) {
                        this.resolveUnknownAgainstDerived(valueType);
                    }
                } else if (this.type.isArray() && this.value instanceof ArrayInitExpression) {
                    Type valueType = this.value.typeCheck(this.type);
                    if (this.type.isUndefined()) {
                        this.resolveUnknownAgainstDerived(valueType);
                    }
                } else if (this.value instanceof NullLiteral) {
                    if (this.type.isUndefined()) {
                        throw new TypeException("Binding.typecheck unknown type for binding " + this.name);
                    }
                    this.value.typeCheck(this.type);
                } else {
                    Type valueType = this.value.typeCheck(Type.UNDEFINED);
                    if (this.type.isUndefined()) {
                        this.resolveUnknownAgainstDerived(valueType);
                    } else if (!this.type.isAssignableFrom(valueType)) {
                        if (valueType == Type.VOID || !valueType.isAssignableFrom(this.type)) {
                            throw new TypeException("Binding.typecheck : incompatible type for binding expression " + valueType + this.value.getPos());
                        }
                        this.doCheckCast = true;
                    } else if (this.type == Type.STRING && valueType != Type.STRING) {
                        this.doCheckCast = true;
                    }
                }
            } else {
                Type valueType;
                this.type = valueType = this.value.typeCheck(expected);
            }
        } else if (this.type.isUndefined()) {
            throw new TypeException("Binding.typecheck unknown type for binding " + this.name);
        }
        return this.type;
    }

    private void resolveUnknownAgainstDerived(Type derived) throws TypeException {
        Class derivedClazz;
        Class nextClazz;
        if (this.type.isArray()) {
            throw new TypeException("Binding.typecheck unknown type for binding " + this.name);
        }
        String typename = this.type.getName();
        for (nextClazz = derivedClazz = Type.dereference(derived).getTargetClass(); nextClazz != null; nextClazz = nextClazz.getSuperclass()) {
            String clazzName = nextClazz.getCanonicalName();
            if (!clazzName.endsWith(typename)) continue;
            this.getTypeGroup().create(clazzName, nextClazz);
            return;
        }
        ArrayList allInterfaces = new ArrayList();
        LinkedList toCheck = new LinkedList();
        toCheck.addLast(derivedClazz);
        while (!toCheck.isEmpty() && (nextClazz = (Class)toCheck.pop()) != null) {
            Class nextSuper;
            if (!nextClazz.isInterface() && (nextSuper = nextClazz.getSuperclass()) != null) {
                toCheck.addLast(nextSuper);
            }
            Class<?>[] interfaces = nextClazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> nextInterface = interfaces[i];
                if (allInterfaces.contains(nextInterface)) continue;
                String interfaceName = nextInterface.getCanonicalName();
                if (interfaceName.endsWith(typename)) {
                    this.getTypeGroup().create(interfaceName, nextInterface);
                    return;
                }
                allInterfaces.add(nextInterface);
                toCheck.addLast(nextInterface);
            }
        }
        throw new TypeException("Binding.typecheck unknown type for binding " + this.name);
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.isBindVar()) {
            Object result = this.value.interpret(helper);
            if (this.type.isPrimitive()) {
                result = this.rebox(this.value.getType(), this.type, result);
            } else if (this.doCheckCast) {
                if (this.type == Type.STRING) {
                    result = result.toString();
                } else if (!this.type.getTargetClass().isInstance(result)) {
                    throw new ClassCastException("Cannot cast " + result + " to class " + this.type);
                }
            }
            helper.setBinding(this.getName(), result);
            return result;
        }
        return null;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (this.alias != null) {
            this.alias.compile(mv, compileContext);
        } else if (this.isBindVar()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.name);
            compileContext.addStackCount(2);
            this.value.compile(mv, compileContext);
            if (this.type.isPrimitive()) {
                this.compileTypeConversion(this.value.getType(), this.type, mv, compileContext);
                this.compileBox(Type.boxType(this.type), mv, compileContext);
            } else if (this.doCheckCast) {
                if (this.type == Type.STRING) {
                    this.compileTypeConversion(this.value.getType(), this.type, mv, compileContext);
                } else {
                    mv.visitTypeInsn(192, this.type.getInternalName());
                }
            }
            mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "setBinding", "(Ljava/lang/String;Ljava/lang/Object;)V");
            compileContext.addStackCount(-3);
        }
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        if (this.alias != null) {
            return this.alias.getValue();
        }
        return this.value;
    }

    public Expression setValue(Expression value) {
        Expression oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public Type getType() {
        if (this.alias != null) {
            return this.alias.getType();
        }
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getCallArrayIndex() {
        if (this.alias != null) {
            return this.alias.getCallArrayIndex();
        }
        return this.callArrayIndex;
    }

    public void setCallArrayIndex(int callArrayIndex) {
        this.callArrayIndex = callArrayIndex;
    }

    public int getLocalIndex() {
        if (this.alias != null) {
            return this.alias.getLocalIndex();
        }
        return this.localIndex;
    }

    public void setLocalIndex(int localIndex) {
        this.localIndex = localIndex;
    }

    public boolean isParam() {
        return this.index > 0;
    }

    public boolean isRecipient() {
        return this.index == 0;
    }

    public boolean isHelper() {
        return this.index == -1;
    }

    public boolean isBindVar() {
        return this.index == -2;
    }

    public boolean isLocalVar() {
        return this.index == -3;
    }

    public boolean isReturn() {
        return this.index == -4;
    }

    public boolean isThrowable() {
        return this.index == -5;
    }

    public boolean isParamCount() {
        return this.index == -6;
    }

    public boolean isParamArray() {
        return this.index == -7;
    }

    public boolean isInvokeParamArray() {
        return this.index == -8;
    }

    public boolean isTriggerClass() {
        return this.index == -9;
    }

    public boolean isTriggerMethod() {
        return this.index == -10;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String desc) {
        this.descriptor = desc;
    }

    public void setUpdated() {
        this.updated = true;
        if (this.alias != null) {
            this.alias.setUpdated();
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.isHelper()) {
            stringWriter.write(this.name);
        } else if (this.isParam() || this.isRecipient()) {
            stringWriter.write(this.name);
            if (this.type != null && (this.type.isDefined() || this.type.isObject())) {
                stringWriter.write(" : ");
                stringWriter.write(this.type.getName());
            }
        } else {
            stringWriter.write(this.name);
            if (this.type != null && (this.type.isDefined() || this.type.isObject())) {
                stringWriter.write(" : ");
                stringWriter.write(this.type.getName());
            }
        }
        if (this.value != null) {
            stringWriter.write(" = ");
            this.value.writeTo(stringWriter);
        }
    }

    public void aliasTo(Binding alias) {
        if (this.isLocalVar()) {
            this.alias = alias;
            if (this.updated) {
                alias.updated = true;
            }
        } else {
            System.out.println("Binding : attempt to alias non-local var " + this.getName() + " to " + alias.getName());
        }
    }

    public boolean isAlias() {
        return this.alias != null;
    }

    public Binding getAlias() {
        return this.alias;
    }
}

