/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.util;

import com.github.fungal.api.util.JMX;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanService {
    private MBeanServer mbeanServer = null;
    private String objectName = null;
    private Object object = null;
    private ObjectName on = null;
    private boolean registered = false;

    public void setMBeanServer(MBeanServer v) {
        this.mbeanServer = v;
    }

    public void setObjectName(String v) {
        this.objectName = v;
    }

    public void setObject(Object v) {
        this.object = v;
    }

    public void start() throws Throwable {
        if (this.mbeanServer == null) {
            throw new IllegalArgumentException("MBeanServer is null");
        }
        if (this.objectName == null) {
            throw new IllegalArgumentException("ObjectName is null");
        }
        if (this.objectName.trim().equals("")) {
            throw new IllegalArgumentException("ObjectName is empty");
        }
        if (this.object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.on = new ObjectName(this.objectName);
        try {
            this.mbeanServer.registerMBean(this.object, this.on);
        }
        catch (NotCompliantMBeanException ncme) {
            this.mbeanServer.registerMBean(JMX.createMBean(this.object), this.on);
        }
        this.registered = true;
    }

    public void stop() throws Throwable {
        if (this.registered) {
            this.mbeanServer.unregisterMBean(this.on);
        }
    }
}

